---
id: 6729959bf9c8e835f46b3f78
title: When Should You Use the Emphasis Element Over the Idiomatic Text Element?
challengeType: 19
dashedName: when-should-you-use-the-emphasis-element-over-the-idiomatic-text-element
---

# --interactive--

These elements are very closely related to the concepts of presentational and semantic HTML. The idiomatic text element, `i`, was originally used for presentational purposes to display the text in italics. But now, it is frequently used for highlighting alternative voice or mood, idiomatic terms from another language, technical terms, and thoughts.

Here is an example from the official HTML spec, using the `i` element to show an idiomatic phrase in French.

:::interactive_editor

```html
<p>There is a certain <i lang="fr">je ne sais quoi</i> in the air.</p>
```

:::

The `lang` attribute inside the open `<i>` tag is used to specify the language of the content. In this case, the language would be French. The `i` element does not indicate if the text is important or not, it only shows that it's somehow different from the surrounding text.

If you do need to emphasize the importance of the text, you can use a similar semantic element called the emphasis element, `em`. This is usually recommended if you need to provide more context. You should use this element for parts of the text that require a special emphasis compared to surrounding text. It's usually limited to only a few words, because it can alter the meaning of the sentence.

This is an example of the emphasis element within a paragraph. 

:::interactive_editor

```html
<p>
  Never give up on <em>your</em> dreams.
</p>
```

:::

You can see the sentence `Never give up on your dreams`. Notice that the word `your` will be emphasized, because it's inside this element. In the browser you would see the word `your` is italicized to tell readers that this is an important word in the sentence.

Even if it looks the same when the text was inside the idiomatic text element, the semantic emphasis element conveys its meaning and importance behind the scenes.

It's important to know that these elements should not be used for presentational purposes only. If you need to display the text in italics, but the text doesn't have a special purpose, style, or meaning in the paragraph, you should use CSS instead.

# --questions--

## --text--

Which HTML element is used to differentiate text from its surrounding content without conveying specific importance?

## --answers--

`em`

### --feedback--

Think about an element that primarily affects text style to highlight when part of the text is different from the overall narrative style.

---

`strong`

### --feedback--

Think about an element that primarily affects text style to highlight when part of the text is different from the overall narrative style.

---

`i`

---

`mark`

### --feedback--

Think about an element that primarily affects text style to highlight when part of the text is different from the overall narrative style.

## --video-solution--

3

## --text--

When should you use CSS instead of the `i` or `em` elements?

## --answers--

When the text has a special purpose or meaning in the paragraph.

### --feedback--

Consider the scenario where the styling is purely visual without any semantic meaning.

---

When you want to display text in italics for presentational purposes only.

---

When the text is an idiomatic expression.

### --feedback--

Consider the scenario where the styling is purely visual without any semantic meaning.

---

When the text needs to be emphasized for importance.

### --feedback--

Consider the scenario where the styling is purely visual without any semantic meaning.

## --video-solution--

2

## --text--

What is the primary difference between `i` and `em`?

## --answers--

There is no difference; they both emphasize text.

### --feedback--

Consider the semantic meaning of each tag and their potential uses.

---

`i` indicates that the text differs from the surrounding content, while `em` emphasizes important text.

---

`i` is for emphasis, while `em` is for styling.

### --feedback--

Consider the semantic meaning of each tag and their potential uses.

---

They both emphasize text the same way, but `em` conveys more importance.

### --feedback--

Consider the semantic meaning of each tag and their potential uses.

## --video-solution--

2
