---
id: 672c3a8fac7c5613b4bb75de
title: What Is Absolute Positioning, and How Does It Work?
challengeType: 19
dashedName: what-is-absolute-positioning
---

# --interactive--

Absolute positioning allows you to take an element out of the normal document flow, making it behave independently from other elements. When an element is positioned absolutely, it is placed in its own layer, completely separate from everything else in the layout. This makes it useful for creating floating UI features such as modals, tooltips, or dropdown menus, which can overlap other elements on the page.

By default, absolutely positioned elements are placed relative to the closest positioned ancestor. If no positioned ancestor is found, the element will be positioned relative to the initial containing block, which is usually the browser's viewport. You can move the absolutely positioned element around using the `top`, `bottom`, `left`, and `right` properties to specify how far away it should be from the edges of its containing element.

For example, setting `top: 30px` and `left: 30px` will move the element `30px` away from the top and left edges of the containing block. Here's an example of how to apply absolute positioning to an element in CSS:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="positioned">Absolutely Positioned</div>
```

```css
body {
  background-color: #eeeeee;
}

.positioned {
  position: absolute;
  top: 30px;
  left: 30px;
  background-color: coral;
}
```

:::

When this code is applied, the element will be removed from the normal document flow and placed `30px` away from the top and left of its containing block.

Absolute positioning can be especially helpful for creating elements that are meant to float over the rest of the content, like overlays or modal windows. However, since the element is removed from the document flow, it can also create gaps or cause other elements to collapse together if not handled properly.

# --questions--

## --text--

What happens when an element is positioned absolutely in CSS?

## --answers--

The element is placed in its normal document flow.

### --feedback--

Absolute positioning removes the element from the normal document flow.

---

The element overlaps other elements and is placed in its own layer.

---

The element is hidden.

### --feedback--

Absolute positioning removes the element from the normal document flow.

---

The element is moved to the top of the page.

### --feedback--

Absolute positioning removes the element from the normal document flow.

## --video-solution--

2

## --text--

How do you move an absolutely positioned element 30px away from the top and left edges of its containing block?

## --answers--

Set `top: 30px` and `left: 30px`.

---

Set `margin-top: 30px` and `margin-left: 30px`.

### --feedback--

Use the `top` and `left` properties.

---

Set `position: relative`.

### --feedback--

Use the `top` and `left` properties.

---

Set `padding: 30px`.

### --feedback--

Use the `top` and `left` properties.

## --video-solution--

1

## --text--

If no positioned ancestor is found, where is an absolutely positioned element placed?

## --answers--

Relative to the body.

### --feedback--

Consider what the element falls back to when no positioned ancestor is available.

---

Relative to the closest fixed element.

### --feedback--

Consider what the element falls back to when no positioned ancestor is available.

---

Relative to the initial containing block (usually the browser's viewport).

---

It stays in the same place.

### --feedback--

Consider what the element falls back to when no positioned ancestor is available.

## --video-solution--

3
