---
id: 672c3a84fb8d4613776cc99e
title: What Is Relative Positioning, and How Does This Differ from the Default Static Positioning?
challengeType: 19
dashedName: what-is-relative-positioning
---

# --interactive--

In CSS, positioning allows us to control how elements are laid out on a page. Two common types of positioning are static positioning and relative positioning. By default, elements are statically positioned. This means they follow the normal flow of the document, one after another, from top to bottom, left to right. 

Static positioning is the default for all elements and doesn't need any special declaration in CSS. You won’t notice anything different when using static positioning because it just keeps elements where they naturally occur in the document. Here is an example of a paragraph using default static positioning:

:::interactive_editor

```html
<p>This paragraph is statically positioned.</p>
```

:::

When rendered in the browser, this paragraph will appear in its natural position, following the normal document flow. No special styling is applied to move it, and it remains where it would naturally appear in the layout.

Relative positioning, on the other hand, allows an element to be shifted from its normal position without disrupting the flow of the document. Think of it as moving the element from its default static position by giving it new coordinates. Here is how you might apply relative positioning:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p class="relative">This paragraph is positioned relatively.</p>
```

```css
body {
  border: solid 1px black;
}

.relative {
  position: relative;
  top: 30px;
  left: 30px;
}
```

:::

In this example, the paragraph will appear `30px` down and `30px` to the right from its original position. However, the space it would have occupied in the normal flow remains preserved. Relative positioning is very useful when you want to move an element slightly without affecting the rest of the layout.

# --questions--

## --text--

Which of the following is the default positioning for all elements?

## --answers--

`absolute`

### --feedback--

Think about what kind of positioning doesn't need any special CSS declaration.

---

`relative`

### --feedback--

Think about what kind of positioning doesn't need any special CSS declaration.

---

`fixed`

### --feedback--

Think about what kind of positioning doesn't need any special CSS declaration.

---

`static`

## --video-solution--

4

## --text--

What does relative positioning do to an element?

## --answers--

It moves it from the normal document flow.

### --feedback--

Relative positioning shifts the element, but only within its original spot in the layout.

---

It moves it relative to its normal position.

---

Fixes it to the viewport.

### --feedback--

Relative positioning shifts the element, but only within its original spot in the layout.

---

It stacks it above other elements.

### --feedback--

Relative positioning shifts the element, but only within its original spot in the layout.

## --video-solution--

2

## --text--

How does relative positioning differ from static positioning?

## --answers--

Relative positioning removes the element from the document flow.

### --feedback--

Static positioning is passive, while relative positioning allows you to move an element around.

---

Static positioning allows elements to be shifted from their default position.

### --feedback--

Static positioning is passive, while relative positioning allows you to move an element around.

---

Relative positioning allows you to shift an element without disrupting the document flow.

---

Static positioning fixes the element in place like a background image.

### --feedback--

Static positioning is passive, while relative positioning allows you to move an element around.

## --video-solution--

3
