---
id: 673403ca2bb16658309e3632
title: How Does the This Keyword Work?
challengeType: 19
dashedName: how-does-the-this-keyword-work
---

# --interactive--

You learned that classes are like blueprints that you can use to create objects.

These blueprints need a general way to refer to the specific object that is being created, accessed, or modified within the code. That's exactly what the `this` keyword is used for. It refers to the context where the code is supposed to run. If you use it within a method, the value of `this` will be a reference to the object associated to that method. This way, you can access the properties and methods of the object within the class and reuse the method on different objects.

For example, here we have a `Dessert` class. This time, we're defining a `hasPeanuts` property.

```js
class Dessert {
  constructor(hasPeanuts) {
    this.hasPeanuts = hasPeanuts;
  }
}
```

Notice that we're using the `this` keyword within the constructor. Remember that the constructor is called automatically when a new object of the class is created.

The `this` keyword is telling the program that `hasPeanuts` should be a property of the object that is currently being created.

The right-hand side of the assignment statement is assigning the value of the `hasPeanuts` parameter to the `hasPeanuts` property of the new object.

```js
this.hasPeanuts = hasPeanuts;
```

That's in the context of the constructor but you can also use the `this` keyword within other methods.

This is our `Dessert` class with a few changes. Now we have two properties: `name` and `price`.

```js
class Dessert {
  constructor(name, price) {
    this.name = name;
    this.price = price;
  }

  showPrice() {
    console.log(`The price of ${this.name} is $${this.price}.`);
  }
}
```

We also have a new `showPrice` method. In this method, we print a descriptive message to the console with the name and the price of the dessert object.

Notice how we're using the `this` keyword to access the properties of the object within the `showPrice` method.

What value will the `this` keyword have in the context of this method? It will refer to the object on which the method is being called. In this case, we're creating a new Dessert instance with the name `"Brownie"` and the price `$5.99`:

```js
const brownie = new Dessert("Brownie", 5.99);
```

If we call the `.showPrice()` method on this object:

```js
brownie.showPrice();
```

Here is the full example:

:::interactive_editor

```js
class Dessert {
  constructor(name, price) {
    this.name = name;
    this.price = price;
  }

  showPrice() {
    console.log(`The price of ${this.name} is $${this.price}.`);
  }
}

const brownie = new Dessert("Brownie", 5.99);
brownie.showPrice();
console.log(brownie);
```

:::

The name and price of the current object (`brownie`) are replaced in the string.

This is all thanks to the `this` keyword, which gives you a general way to refer to the current object within the class. This allows you to reuse the method on different objects.

This is in the context of object methods but the `this` keyword will also have a value in standalone functions and arrow functions.

Its value within a standalone function typically refers to the global object (in non-strict mode) or `undefined` (in strict mode).

The value of the `this` keyword is a bit different in arrow functions. Arrow functions inherit the value of `this` from the enclosing scope where they are defined. They don't create their own `this` binding. That means that the value of `this` depends on the context where the arrow function is defined, not where or how the arrow function is called. This makes arrow functions helpful for callbacks or for preserving context.

However, because of this, the value of `this` will not refer to the current object in object methods, so this is something that you should keep in mind when working with arrow functions.

The same applies to arrow functions defined within other functions. They will inherit the value of `this` from their parent scope.

The `this` keyword is a powerful tool for accessing and manipulating objects. Understanding how it works is essential for mastering object-oriented programming in JavaScript.

# --questions--

## --text--

What is the primary purpose of the `this` keyword in JavaScript?

## --answers--

To define a new object.

### --feedback--

Think about how `this` is used within methods.

---

To access properties and methods of the current object.

---

To create functions.

### --feedback--

Think about how `this` is used within methods.

---

To call methods on other objects.

### --feedback--

Think about how `this` is used within methods.

## --video-solution--

2

## --text--

Which of the following statements is true about `this` in JavaScript methods?

## --answers--

`this` always refers to the global object.

### --feedback--

Think about how the value of `this` can change based on the context.

---

`this` is always bound to the object that the function is defined within.

### --feedback--

Think about how the value of `this` can change based on the context.

---

`this` can refer to different objects depending on the context in which it is used.

---

`this` is only used in functional programming.

### --feedback--

Think about how the value of `this` can change based on the context.

## --video-solution--

3

## --text--

In which of the following scenarios would you typically use the `this` keyword?

## --answers--

When defining functions.

### --feedback--

Think about the common use cases for `this`.

---

When accessing properties and methods of an object.

---

When calling functions.

### --feedback--

Think about the common use cases for `this`.

---

When creating new objects.

### --feedback--

Think about the common use cases for `this`.

## --video-solution--

2
