---
id: 6733affc29df1304e2c97e88
title: What Are Classes, and How Do They Work in JavaScript?
challengeType: 19
dashedName: what-are-classes-and-how-do-they-work-in-javascript
---

# --interactive--

In modern JavaScript, classes are like blueprints that you can define in code for creating multiple objects of the same kind.

For example, if you're modeling an inventory system, you'll need to create multiple objects per type of product.

Each individual product will have its own properties and actions but products of the same kind can be created from the same "blueprint". That's what classes are used for.

Classes can be defined as either a class expression or class declaration.

Here is the basic syntax for a class declaration:

```js
class MyClassName {
  // Class Methods
  constructor() { ... }
  method1() { ... }
  method2() { ... }
  ...
}
```

You start by writing the `class` keyword followed by the name of the class. When naming classes, you should use the `PascalCase` naming convention instead of `camelCase`.

The content inside the curly braces is known as the class body. This is where the constructor and methods will go.

The constructor is a special method that gets called automatically when a new object is created from the class. It is typically used to initialize the properties of the object.

In this example, you can see a `Dog` class with a constructor.

```js
class Dog {
  constructor(name) {
    this.name = name;
  }
}
```

The `this` keyword is used here to refer to the current instance of the `Dog` class, allowing you to assign the `name` property to the object being created. You will learn more about the `this` keyword in a future lesson.

Below the constructor, you can have what are called methods. Methods are functions defined inside a class that perform actions or operations. They are used to define behaviors that instances of the class can perform.

Here is an example of adding a method called `bark` to the `Dog` class.

```js
class Dog {
  constructor(name) {
    this.name = name;
  }

  bark() {
    console.log(`${this.name} says woof!`);
  }
}
```

When the `bark` method gets called the message will be logged to the console with the actual name that was passed into it. If you create a `Dog` instance with the name `"Buddy"`, calling the `bark()` method on that instance will print `"Buddy says woof!"` to the console.

Once you have your class defined, you can create an instance of the class with the `new` keyword, the name of the class, and its arguments.

In this example, we create a new `Dog` instance with the name `Gino` and then we assign it to the variable `dog`.

```js
const dog = new Dog("Gino");
```

When you write `new Dog("Gino")` in your code, the new object is created and the constructor is called automatically with the given arguments.

You can then access this property using the dot notation, like you can see in the following line of code:

```js
console.log(dog.name);
```

Here is the full example:

:::interactive_editor

```js
class Dog {
  constructor(name) {
    this.name = name;
  }

  bark() {
    console.log(`${this.name} says woof!`);
  }
}

const dog = new Dog("Gino");
console.log(dog.name);
```

:::

You can also call methods. In this example, we are calling the `bark()` method on the `dog` instance.

```js
dog.bark();
```

Here is the full example with the method call included:

:::interactive_editor

```js
class Dog {
  constructor(name) {
    this.name = name;
  } 
  bark() {
    console.log(`${this.name} says woof!`);
  }
}

const dog = new Dog("Gino");
console.log(dog.name);
dog.bark();
```

:::

As mentioned earlier, you can also define classes as a class expression. This is where the class is anonymous and assigned to a variable.

Here is what the earlier example looks like as a class expression:

```js
const Dog = class {
  constructor(name) {
    this.name = name;
  }

  bark() {
    console.log(`${this.name} says woof!`);
  }
};
```

Most of the time, you'll use class declarations, but understanding class expressions is also valuable, as they can offer more flexibility, especially in dynamic programming situations.

By using classes and understanding their basic syntax, you can create reusable code, organize it into logical units, and promote code modularity.

# --questions--

## --text--

What is the primary purpose of a constructor in a JavaScript class?

## --answers--

To define the methods of the class.

### --feedback--

Think about the initialization process of an object.

---

To initialize the properties of an object when it is created.

---

To clone instance of the class.

### --feedback--

Think about the initialization process of an object.

---

To inherit properties and methods from another class.

### --feedback--

Think about the initialization process of an object.

## --video-solution--

2

## --text--

What is the correct way to create an instance of a JavaScript class?

## --answers--

Using the `new` keyword followed by the class name and arguments.

---

By directly calling the class name.

### --feedback--

Think about how to create a new object based on a class definition.

---

By using the `create` method of the class.

### --feedback--

Think about how to create a new object based on a class definition.

---

By using the `instantiate` keyword.

### --feedback--

Think about how to create a new object based on a class definition.

## --video-solution--

1

## --text--

What is the difference between a class and an object in JavaScript?

## --answers--

A class is an instance of an object.

### --feedback--

Think about the relationship between a class and the objects it creates.

---

An object is a clone of a class.

### --feedback--

Think about the relationship between a class and the objects it creates.

---

There is no difference between a class and an object.

### --feedback--

Think about the relationship between a class and the objects it creates.

---

A class is a blueprint for an object, while an object is a specific instance of that class.

## --video-solution--

4
