---
id: 6733b0451d6be0065430b418
title: What Is Functional Programming?
challengeType: 19
dashedName: what-is-functional-programming
---

# --interactive--

Functional programming is about writing code that is clean, predictable, and easier to test and debug. Two key concepts we'll explore today are pure functions and avoiding side effects.

Let's start with pure functions. 

A pure function is a function that, given the same input, will always return the same output, and it doesn't modify anything outside of itself.

Here's an example of a pure function:

```js
function add(a, b) {
  return a + b;
}
```

This function is pure because it always returns the same result for the same inputs, and it doesn't change anything outside of itself. No matter how many times you call `add(2, 3)`, it will always return `5`, and it won't affect any other part of your program.

Now, let's contrast this with an impure function:

```js
let total = 0;
function addToTotal(value) {
  total += value;
  return total;
}
```

This function is impure because it modifies a variable outside of itself (`total`). The result of `addToTotal(5)` will be different depending on what `total` was before the function was called. This unpredictability can make our code harder to understand and debug.

This brings us to our next important concept and that is side effects.

A side effect is any change that occurs in the state of the program when a function is called. This could include modifying a global variable, writing to a file, or making an API call.

Pure functions have no side effects but impure functions have these.

Avoiding side effects is a key principle of functional programming. When we minimize side effects, our code becomes more predictable and easier to test. 

While writing code, our main goal should be to make functions do one thing and they should do it very well without changing other parts of our program.

Here's an example of a function with a side effect:

:::interactive_editor

```js
function greet(name) {
  console.log(`Hello, ${name}!`);
}

greet("Alice");
```

:::

This function has a side effect because it interacts with the outside world by logging to the console. 

In functional programming, we might rewrite this as:

:::interactive_editor

```js
function greet(name) {
  return `Hello, ${name}!`;
}
console.log(greet("Alice"));
```

:::

Now `greet` is a pure function that simply returns a string, and we handle the side effect (logging to the console) separately.

Functional programming encourages us to compose our programs using pure functions by breaking our code into small, predictable pieces. And thus, we can build programs that are easier to understand, test, and maintain.

# --questions--

## --text--

What is a key characteristic of a pure function?

## --answers--

It always modifies global state.

### --feedback--

Think about what we said regarding the predictability of pure functions.

---

It produces different outputs for the same input.

### --feedback--

Think about what we said regarding the predictability of pure functions.

---

It always produces the same output for the same input.

---

It always performs I/O operations.

### --feedback--

Think about what we said regarding the predictability of pure functions.

## --video-solution--

3

## --text--

Which of the following is considered a side effect in functional programming?

## --answers--

Returning a value from a function.

---

Creating a new object within a function.

### --feedback--

Recall what we discussed about functions interacting with their external environment.

---

Modifying a global variable.

---

Using local variables within a function.

### --feedback--

Recall what we discussed about functions interacting with their external environment.

## --video-solution--

3

## --text--

What is a benefit of avoiding side effects in functional programming?

## --answers--

It makes the code run faster.

### --feedback--

Consider what we said about the predictability and testability of code without side effects.

---

It reduces the amount of code needed.

### --feedback--

Consider what we said about the predictability and testability of code without side effects.

---

It makes the code easier to understand and test.

---

It eliminates the need for functions altogether.

### --feedback--

Consider what we said about the predictability and testability of code without side effects.

## --video-solution--

3
