---
id: 688166750663c22e2b1c8e80
title: What Is Bash Scripting, and What Are Some Advantages to Using It?
challengeType: 19
dashedName: what-is-bash-scripting-and-what-are-some-advantages-to-using-it
---

# --description--

In previous lessons, you learned about Bash and some of the common commands you might use. But Bash supports a full scripting language, which you can use to perform more complex automated tasks.

Bash scripting involves writing a sequence of Bash commands in a file, which you can then execute with Bash to run the contents of the file.

Let's look at what a bash script may look like:

```bash
#!/bin/bash

servers=("prod" "dev")

for server in "${servers[@]}"
do
  echo "Pulling $server"
  rsync --archive --verbose $server:/etc/nginx/conf.d/server.conf configs/$server.conf
done
```

This script pulls NGINX configuration files from a list of remote servers, which can be useful for backing up those configs into a local repository. NGINX is a popular web server and you will learn more about working with servers in a future module. 

The first line is called a "shebang" (`#!`) and tells the system which interpreter should be used to run the script. Common values here are `/usr/bin/bash`, `/bin/bash`, or `/bin/sh`.

The first line, `servers=("prod" "dev")`, instantiates a list of strings representing the server names. `"prod"` is often used to refer to the production site, while `"dev"` refers to the development site, which is typically used for testing new features and changes before they are deployed to the live production environment.

Then, the list is iterated through with a `for` loop - the `servers[@]` syntax expands the list into individual elements. Each element is assigned to server with each iteration.

The `do` statement indicates the beginning of the loop's logical block, or the code that should run with each iteration.

`echo "Pulling $server"` interpolates the current value of the server variable, which would be prod or dev in this case, and logs it to the terminal.

Then `rsync` is used to pull the actual file from the server and save it locally, using more interpolation to manage that command.

`done` indicates the end of the loop's logical block.

There are a number of significant advantages to understanding and leveraging Bash scripting.

The first is that nearly every Unix environment comes with Bash readily available, which means you can run your script as-is without having to configure any language runtimes like Node.js or Python.

The second is that you have access to all of the binary applications available on the system with minimal effort. If your system has doctl installed, your script can execute that binary. A binary is a compiled program that the computer runs. When you have a bash script, you can execute the binary which will launch the program.

And finally, the syntax you use for your script is also executable directly in the terminal. This means that testing a small portion of your script becomes much less convoluted - you can copy and paste that portion directly into your terminal and see the result!

Understanding Bash will not only level up your scripting game, but will make you a wizard in the command line!

# --questions--

## --text--

What is the purpose of the "shebang" line in a Bash script?

## --answers--

It's a comment that describes what the script does.

### --feedback--

The shebang appears at the very beginning of a script file.

---

It indicates what interpreter should be used for the script.

---

It defines the variables used in the script.

### --feedback--

The shebang appears at the very beginning of a script file.

---

It marks the beginning of a for loop.

### --feedback--

The shebang appears at the very beginning of a script file.

## --video-solution--

2

## --text--

In the example script, what does the line for server in `"${servers[@]}"` accomplish?

## --answers--

It creates a new array of servers.

### --feedback--

Think about what a for loop typically does.

---

It iterates through each element in the servers array.

---

It counts how many servers are in the array.

### --feedback--

Think about what a for loop typically does.

---

It deletes the server array.

### --feedback--

Think about what a for loop typically does.

## --video-solution--

2

## --text--

Which of the following is NOT mentioned as an advantage of Bash scripting?

## --answers--

Bash is available in nearly every Unix environment.

### --feedback--

Review the advantages listed in the lesson.

---

You can access all binary applications on the system.

### --feedback--

Review the advantages listed in the lesson.

---

Bash scripts run faster than Python or JavaScript.

---

You can test portions of your script directly in the terminal.

### --feedback--

Review the advantages listed in the lesson.

## --video-solution--

3
