---
id: 673407a223891b6734563c89
title: What Is the Fetch API, and What Are Common Types of Resources That Are Fetched from the Network?
challengeType: 19
dashedName: what-is-the-fetch-api-and-what-are-common-types-of-resources-that-are-fetched-from-the-network
---

# --description--

The Fetch API allows web apps to make network requests, typically to retrieve or send data to the server. This API provides a `fetch()` method that you can use to make these requests. Let's look at a basic example of how to use `fetch`:

```js
fetch('https://api.example.com/data')
```

In this example, we're making a `GET` request to `https://api.example.com/data`. This will then return us some data that we need to convert to JSON format and can use anywhere we want to. 

By default, the Fetch API uses the `GET` method to retrieve data. This will be covered in the next lesson, along with other common HTTP request methods.

Now, let's discuss some common types of resources that are fetched from the network.

In our web apps, we need some common data like weather data, professions list data, country names list, country code or country flag icons/images. Using these data we can make our app more informative and interactive. Thanks to Fetch API, we can get these resources from the network.

Images are some frequently fetched resources. You might use fetch to load images statically or dynamically based on user actions, and display them on your web app.

Text files are another type of resource often fetched. This could include configuration files, log files, or even entire documents that you want to display on your webpage.

In some cases, you might fetch audio or video files. The Fetch API can handle these types of resources as well, allowing you to work with a wide variety of data types.

# --questions--

## --text--

What is the primary purpose of the Fetch API in JavaScript?

## --answers--

To create new HTML elements.

### --feedback--

Think about what fetch allows you to do in relation to servers.

---

To make network requests and retrieve resources.

---

To manipulate the DOM.

### --feedback--

Think about what fetch allows you to do in relation to servers.

---

To store data in the browser.

### --feedback--

Think about what fetch allows you to do in relation to servers.

## --video-solution--

2

## --text--

What type of data is commonly received from a fetch request to an API?

## --answers--

PDF

### --feedback--

Consider what format is easy for JavaScript to work with.

---

JSON

---

MP3

### --feedback--

Consider what format is easy for JavaScript to work with.

---

EXE

### --feedback--

Consider what format is easy for JavaScript to work with.

## --video-solution--

2

## --text--

Which of the following is NOT a common type of resource fetched from the network?

## --answers--

JSON data.

### --feedback--

Think about what types of data are typically stored on servers and retrieved by web applications.

---

HTML content.

### --feedback--

Think about what types of data are typically stored on servers and retrieved by web applications.

---

JavaScript functions.

---

Image files.

### --feedback--

Think about what types of data are typically stored on servers and retrieved by web applications.

## --video-solution--

3
