---
id: 67340798c2c1776709d8a5fe
title: How Does the Async Attribute Work Inside Script Elements, and How Does It Differ from the Defer Attribute?
challengeType: 19
dashedName: how-does-the-async-attribute-work-inside-script-elements-and-how-does-it-differ-from-the-defer-attribute
---

# --description--

The `async` and `defer` attributes in HTML `script` elements play a crucial role in how JavaScript files are loaded and executed in web pages. Understanding them can improve your website's performance and user experience. When you include a `script` in your HTML file, it looks like this:

```js
<script src="example.js"></script>
```

When the browser finds this `script` tag, it stops parsing the HTML, downloads the script, executes it, and then continues parsing the HTML. This can slow down the loading of your web page, especially if you have large scripts.

This is where the `async` and `defer` attributes come in. They provide ways to load scripts more efficiently.

Let's start with the `async` attribute:

```js
<script src="example.js" async></script>
```

By adding the `async` attribute to a `script` tag, the browser will continue parsing the HTML while the script is being downloaded. Once the script is fully downloaded, the browser will pause HTML parsing, execute the script, and then resume parsing the HTML. This can significantly speed up page loading.

It's important to note that async scripts are executed as soon as they're downloaded, which means they might not run in the correct order which we desire. This is where the `defer` attribute comes in for the rescue. Let's look at how the `defer` attribute looks like:

```js
<script src="example.js" defer></script>
```

The `defer` attribute is similar to `async` attribute. However, defer scripts are not executed immediately after they're downloaded. Instead, they wait until the HTML parsing is complete. Furthermore, defer scripts execute in the order they appear in the HTML code.

In short, use `async` for scripts where the order of execution doesn't matter, and use `defer` when you need to ensure that scripts run in the correct order. Both attributes can significantly improve page load times by allowing the browser to continue parsing HTML while scripts are being downloaded in the background.

# --questions--

## --text--

What is the advantage of using the `defer` attribute in a `<script>` tag?

## --answers--

It helps differentiate the script from `async` scripts.

### --feedback--

Remember the purpose and differences of the `defer` and `async` attributes.

---

It reduces memory usage during page load.

### --feedback--

The `defer` attribute has nothing to do with memory management.

---

It can improve the overall page loading performance.

---

It lets developers set a custom delay time before scripts run.

### --feedback--

The `defer` attribute doesn't execute scripts on a custom timer.

## --video-solution--

3

## --text--

In what order will the following scripts be executed?

```html
<script src="1.js" defer></script>
<script src="2.js" async></script>
<script src="3.js" defer></script>
```

## --answers--

`1.js`, `2.js`, `3.js`.

### --feedback--

Remember how `async` and `defer` affect the execution order of scripts.

---

`2.js`, `1.js`, `3.js`.

### --feedback--

Remember how `async` and `defer` affect the execution order of scripts.

---

The order is unpredictable.

---

`1.js`, `3.js`, `2.js`.

### --feedback--

Remember how `async` and `defer` affect the execution order of scripts.

## --video-solution--

3

## --text--

Which statement about `async` and `defer` is true?

## --answers--

`async` scripts are executed in the order they appear in the HTML.

### --feedback--

Think about when `async` and `defer` scripts are executed in relation to HTML parsing.

---

`defer` scripts are executed as soon as they are downloaded.

### --feedback--

Think about when `async` and `defer` scripts are executed in relation to HTML parsing.

---

`async` scripts can be executed before the HTML is fully parsed.

---

`defer` scripts are executed before any `async` scripts.

### --feedback--

Think about when `async` and `defer` scripts are executed in relation to HTML parsing.

## --video-solution--

3
