---
id: 6733b072bd8f5b06ccdbd9e2
title: What Is Asynchronous JavaScript, and How Does It Differ from Synchronous JavaScript?
challengeType: 19
dashedName: what-is-asynchronous-javascript-and-how-does-it-differ-from-synchronous-javascript
---

# --description--

Let’s learn about asynchronous JavaScript. Asynchronous events occur at different times, independently from each other.

In the context of software development, "asynchronous" refers to tasks that run in the background, independently from the main flow of the program. The main advantage of asynchronous processes is that they don’t block the execution of the main program.

That’s particularly helpful for tasks that may take a long time to run, such as fetching data from a remote server, processing large files, handling user input, and performing complex calculations. This is what we know as asynchronous programming.

This approach contrasts with the traditional synchronous programming technique that you have been working with so far. When you write multiple lines of code, you can usually predict what will happen and when it will happen. The first line will be executed, then the second line, and so on in the order that you write them.

In this example, the first line where you define the variable will be executed first, then the second line, and finally the third line where the string is logged to the console:

```js
const topic = "JavaScript";
const learning = `I'm learning ${topic}!`;
console.log(learning);
```

Everything is sequential and predictable. Each line is completed before the next one starts. This type of JavaScript program is known as single-threaded.

The concept of threads is very important. A thread is a unit of execution within a process. It’s like a separate flow of control within the program.

In synchronous programming, threads execute sequentially, one after the other. If a thread is blocked, like waiting for user input, the entire process is blocked until the thread is completed.

In asynchronous programming, threads can be executed concurrently, running multiple threads at the same time. This way, the program can continue running multiple tasks simultaneously without making the main program unresponsive, even if one of the threads is blocked.

Asynchronous programming often involves callbacks, promises, or async/await to handle non-blocking operations.

As you learned in earlier lessons, a callback is a function that you pass to another function to be called later. Event handlers are a particular type of callback that you’ve worked with before. They used to be the most common way to implement asynchronous functions in JavaScript. However, if the callback function also takes other callback functions, the code and logic can get quite complicated very quickly. 

Currently, the most commonly used technique for implementing asynchronous programming in JavaScript is the promise. A `Promise` is an object that represents the eventual completion (or failure) of an asynchronous process and its value.

The value of a promise is not known when the promise is created. It’s only known when the asynchronous process is completed. For example, the process of fetching data from a remote API for your web application may take some time. Meanwhile, you want your users to have a nice user experience, right?

To implement this, you could create a promise to keep the user interface active and interactive while the asynchronous process is running. When the process is completed, the promise will contain the data that was sent back by the API, so the application can handle it or render it appropriately when it’s available.

Asynchronous programming is a powerful tool for building efficient JavaScript applications. By understanding the differences between synchronous and asynchronous programming, you can choose the right approach for your application and write more efficient code.

# --questions--

## --text--

What is the primary difference between synchronous and asynchronous programming?

## --answers--

Synchronous code executes sequentially, while asynchronous code executes concurrently.

---

Synchronous code is more efficient than asynchronous code.

### --feedback--

Think about how the execution flow differs between the two.

---

Synchronous code is only used for simple tasks, while asynchronous code is used for complex tasks.

### --feedback--

Think about how the execution flow differs between the two.

---

Synchronous code is always faster than asynchronous code.

### --feedback--

Think about how the execution flow differs between the two.

## --video-solution--

1

## --text--

Which of the following is a technique for handling asynchronous operations in JavaScript?

## --answers--

Promises.

### --feedback--

Think about the different ways to handle asynchronous tasks.

---

Callbacks.

### --feedback--

Think about the different ways to handle asynchronous tasks.

---

Event listeners.

### --feedback--

Think about the different ways to handle asynchronous tasks.

---

All of the above.

## --video-solution--

4

## --text--

What is the primary advantage of using asynchronous programming?

## --answers--

Improved performance for CPU-bound tasks.

### --feedback--

Think about how asynchronous programming can prevent the main thread from being blocked.

---

Simpler code structure.

### --feedback--

Think about how asynchronous programming can prevent the main thread from being blocked.

---

Increased responsiveness of applications.

---

Reduced memory usage.

### --feedback--

Think about how asynchronous programming can prevent the main thread from being blocked.

## --video-solution--

3
