---
id: 672b9538c25634394ceb7b8f
title: How Do You Style the Different Link States?
challengeType: 19
dashedName: how-do-you-style-the-different-link-states
---

# --interactive--

There are different states of a link, including `link`, `visited`, `hover`, `focus`, and `active`. These states are important for helping users recognize links and providing clear feedback after interactions, which improves both usability and accessibility.

Styling these different link states is crucial for usability and accessibility, as it provides visual cues about the current state of the link. This helps users understand which links they have visited, which link they are interacting with, and what will happen when they click.

For users with visual impairments or cognitive disabilities, these distinct styles can make navigation much easier and more intuitive.

Additionally, clear link states enhance the overall user experience by providing immediate feedback on user interactions, reducing confusion and improving the site's navigability.

These states can be styled using something called `pseudo-classes` in CSS.

A pseudo-class is a keyword added to a selector that specifies a special state of the selected element.

For example, `:hover` can change a button's color when the user's pointer hovers over it, while `:visited` can change the color of a link that has already been visited.

Pseudo-classes allow you to style elements based on their state or the user's interaction with them, without the need for additional markup in your HTML.

The syntax of a `pseudo-class` looks something like this where `A` is the selector and `:B` is the `pseudo-class`:

```css
A:B {
  property: value;
}
```

To better understand how to style the different link states, let's take a look at some examples.

The `:link` pseudo-class styles unvisited links, indicating that they are clickable.

Here is an example of targeting an anchor element and using the `:link` pseudo-class:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
/* Normal state (unvisited link) */
a:link { 
  color: red;
}
```

:::

The above example will change the link's default blue color to `red` when it is unvisited.

`:visited` styles links that have already been visited or clicked, helping users track which links they have clicked before. Here’s an example usage of `:visited` pseudo-class:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="https://www.freecodecamp.org/learn/" target="_blank">freeCodeCamp</a>
```

```css
/* Visited link */
a:visited {
  color: green;
}
```

:::

This code will color the link to `green` when it is clicked.

`:hover` changes the link's style when the user hovers over it, providing a visual cue that the link is interactive. Here’s an example usage of `:hover` pseudo-class:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
/* Hover state */
a:hover {
  color: green;
}
```

:::

This code will color the links to `green` when mouse is hovered over it.

`:focus` adds styles around the link when it is focused, such as when navigating with a keyboard, or enhancing accessibility.

Here is an example using the `outline` property to apply a solid orange outline when the link is focused.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
/* Focus state */
a:focus {
  outline: 2px solid orange;
}
```

:::

`:active` changes the link's styles while the link is being clicked, providing immediate feedback to the user that their action is being registered. Here’s an example usage of `:active` pseudo-class:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
/* Active state */
a:active {
  color: pink;
}
```

:::

This code example will make the link to `pink` color immediately when the link is clicked.

# --questions--

## --text--

Which CSS pseudo-class is used to style links that have not been visited?

## --answers--

`:visited`

### --feedback--

Think about the default appearance of a link before it has been clicked.

---

`:link`

---

`:hover`

### --feedback--

Think about the default appearance of a link before it has been clicked.

---

`:active`

### --feedback--

Think about the default appearance of a link before it has been clicked.

## --video-solution--

2

## --text--

What visual change does the hover state typically involve in CSS?

## --answers--

The link becomes larger.

### --feedback--

Consider what happens when you move your cursor over a link.

---

The link text color changes.

---

The link text becomes bold.

### --feedback--

Consider what happens when you move your cursor over a link.

---

The link text is underlined.

### --feedback--

Consider what happens when you move your cursor over a link.

## --video-solution--

2

## --text--

Which CSS pseudo-class would you use to add a visible outline around a link when it is navigated to using the keyboard?

## --answers--

`:link`

### --feedback--

Think about the state that indicates keyboard navigation.

---

`:hover`

### --feedback--

Think about the state that indicates keyboard navigation.

---

`:focus`

---

`:active`

### --feedback--

Think about the state that indicates keyboard navigation.

## --video-solution--

3
