---
id: 672aa6441bcd3758e9f52ae0
title: How Do You Space List Items Using margin or line-height?
challengeType: 19
dashedName: how-do-you-space-list-items-using-margin-or-line-height
---

# --interactive--

Margins and line-height are essential for spacing list items to enhance readability and visual appeal.

First, let's start spacing list items using margins!

Margins can be used to create space between list items by applying margin properties to the `li` elements. This method allows you to control the spacing outside each list item, effectively increasing or decreasing the gap between them.

Let's take a look at an example of an unordered list with three list items.

:::interactive_editor

```html
<ul>
  <li>Item 1</li>
  <li>Item 2</li>
  <li>Item 3</li>
</ul>
```

:::

By default, HTML will not apply that much spacing between the list items.

To apply some spacing to the bottom of each list item, you can use the `margin-bottom` property like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<ul>
  <li>Item 1</li>
  <li>Item 2</li>
  <li>Item 3</li>
</ul>
```

```css
li {
  margin-bottom: 40px;
}
```

:::

In this example, `40px` of margin will be applied to the bottom of each list item inside the unordered list.

Another way to space out list items would be to use the `line-height` property.

The `line-height` property adjusts the vertical spacing between lines of text within a single list item.

While it primarily affects the spacing between lines of text within each item, it can also indirectly influence the overall spacing between list items if the items contain only a single line of text.

If list items have multiple lines of text, the `line-height` will affect the spacing between those lines, but it does not directly adjust the spacing between separate list items themselves.

To control the spacing between individual list items, you would use `margin` or `padding` properties instead.

Using the same unordered list from earlier, here is an example of applying `line-height` to the list items:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<ul>
  <li>Item 1</li>
  <li>Item 2</li>
  <li>Item 3</li>
</ul>
```

```css
li {
  line-height: 2; 
}
```

:::

In this example, `line-height: 2;` sets the line height to be twice the font size, creating more vertical space within each list item.

# --questions--

## --text--

Which CSS property would you use to create space between list items by adjusting the space outside each `li` element?

## --answers--

`padding`

### --feedback--

This property affects the space inside the element's `border`.

---

`line-height`

### --feedback--

This property affects the spacing between lines of text, not the space outside the element.

---

`margin`

---

`border`

### --feedback--

This property affects the element's `border`, not the space outside it.

## --video-solution--

3

## --text--

Given the CSS rule `li { margin-bottom: 15px; }`, what effect does this have on list items?

## --answers--

Adds `15px` of space inside each list item.

### --feedback--

This rule affects the space outside the list item, not inside.

---

Adds `15px` of space between the content and `border` of each list item.

### --feedback--

This rule affects the space outside the `border` of each list item.

---

Adds `15px` of space below each list item.

---

Adds `15px` of space above each list item.

### --feedback--

This rule adds space below each list item, not above.

## --video-solution--

3

## --text--

What does the `line-height` property control in CSS?

## --answers--

The `width` of the content.

### --feedback--

This is controlled by the `width` property, not `line-height`.

---

The space inside the `border` of an element.

### --feedback--

This is controlled by properties like `padding`, not `line-height`.

---

The vertical spacing between lines of text within an element.

---

The space outside the `border` of an element.

### --feedback--

This is controlled by properties like `margin`, not `line-height`.

## --video-solution--

3
