---
id: 67fe859e9d3b3635197781c8
title: How Do You Work With Integers and Floating Point Numbers?
challengeType: 19
dashedName: how-do-you-work-with-integers-and-floating-point-numbers
---

# --description--

Integers and floats are the primary numeric data types in Python. With them, you can store numeric data and perform mathematical operations.

Let's look at what integers and floats are, how to perform arithmetic calculations with them, and at several methods Python provides for working with both.

Integers are whole numbers without decimal points, either positive or negative:

```python
my_int_1 = 56
my_int_2 = -4

print(type(my_int_1)) # <class 'int'>
print(type(my_int_2)) # <class 'int'>
```

Here's how to perform an addition operation with integers:

```python
my_int_1 = 56
my_int_2 = 12

sum_ints = my_int_1 + my_int_2
print('Integer Addition:', sum_ints) # Integer Addition: 68
```

Here's how to perform a subtraction with integers:

```python
my_int_1 = 56
my_int_2 = 12

# Subtraction
diff_ints = my_int_1 - my_int_2
print('Integer Subtraction:', diff_ints) # Integer Subtraction: 44
```

Here's how to perform a multiplication operation with integers:

```python
my_int_1 = 12
my_int_2 = 4

# Multiplication
product_ints = my_int_1 * my_int_2
print('Integer Multiplication:', product_ints) # Integer Multiplication: 48
```

And here's how to perform a division operation with integers:

```python
my_int_1 = 56
my_int_2 = 12

# Division
div_ints = my_int_1 / my_int_2
print('Integer Division:', div_ints) # Integer Division: 4.666666666666667
```

Floats are positive or negative numbers with decimal points, like `3.14`, `-0.5`, or `0.0`.

```python
my_float_1 = -12.0
my_float_2 = 4.9

print(type(my_float_1)) # <class 'float'>
print(type(my_float_2)) # <class 'float'>
```

Here's an addition operation with floats:

```python
my_float_1 = 5.4
my_float_2 = 12.0

float_addition = my_float_1 + my_float_2
print('Float Addition:', float_addition) # Float Addition: 17.4
```

Here's a subtraction operation with floats:

```python
my_float_1 = 5.4
my_float_2 = 12.0

float_subtraction = my_float_2 - my_float_1
print('Float Subtraction:', float_subtraction) # Float Subtraction: 6.6
```

Here's a multiplication operation with floats:

```python
my_float_1 = 5.4
my_float_2 = 12.0

float_multiplication = my_float_2 * my_float_1
print('Float Multiplication:', float_multiplication) # Float Multiplication: 64.80000000000001
```

And here's a division operation with floats:

```python
my_float_1 = 5.4
my_float_2 = 12.0

float_division = my_float_2 / my_float_1
print('Float Division:', float_division) # Float Division: 2.222222222222222
```

If you add an integer and a float, the result is automatically converted to a float:

```python
my_int = 56
my_float = 5.4

sum_int_and_float = my_int + my_float

print(sum_int_and_float) # 61.4
print(type(sum_int_and_float)) # <class 'float'>
```

This is true for other basic arithmetic operations, too, like subtraction, multiplication, and division. If you mix integers and floats, Python will return a float as the result.

You can also perform more complex arithmetic calculations such as getting the remainder of two numbers with the modulo operator, floor division, and exponentiation with both integers and floats.

The modulo operator (`%`) returns the remainder when the value on the left is divided by the value on the right:

```python
my_int_1 = 56
my_int_2 = 12

my_float_1 = 5.4
my_float_2 = 12.0

mod_ints = my_int_1 % my_int_2
mod_floats = my_float_2 % my_float_1

print('Integer Modulus:', mod_ints) # Integer Modulus: 8
print('Float Modulus:', mod_floats) # Float Modulus: 1.1999999999999993
```

Floor division divides two numbers and returns the greatest integer less than or equal to the result. This is done with the double forward slash operator (`//`):

```python
my_int_1 = 56
my_int_2 = 12

my_float_1 = 5.4
my_float_2 = 12.0

floor_div_ints = my_int_1 // my_int_2
floor_div_floats = my_float_2 // my_float_1

print('Integer Floor Division:', floor_div_ints) # Integer Floor Division: 4
print('Float Floor Division:', floor_div_floats) # Float Floor Division: 2.0
```

Exponentiation raises a number to the power of another, and is done with the double asterisk operator (`**`):

```python
my_int_1 = 56
my_int_2 = 12

my_float_1 = 5.4
my_float_2 = 12.0

exp_ints = my_int_1 ** my_int_2
exp_floats = my_float_1 ** my_float_2

print('Integer Exponentiation:', exp_ints) # Integer Exponentiation: 951166013805414055936
print('Float Exponentiation:',  exp_floats) # Float Exponentiation: 614787626.1765089
```

Python also provides built-in functions for converting either numeric data or strings into integers or floats. 

The `float()` function returns a floating-point number constructed from the given number:

```python
my_int_1 = 56
my_float_1 = float(my_int_1)

print(my_float_1)  # 56.0
print(type(my_float_1))  # <class 'float'>
```

The `int()` function returns an integer constructed from the given number:

```python
my_float = 12.92563
my_int = int(my_float)

print(my_int)  # 12
print(type(my_int))  # <class 'int'>
```

Also, you can use the same built-in functions to convert a string into either a float or integer:

```python
my_str_int = '45'
my_str_float = '7.8'

converted_int = int(my_str_int)
converted_float = float(my_str_float)

print(converted_int, type(converted_int))  # 45 <class 'int'>
print(converted_float, type(converted_float))  # 7.8 <class 'float'>
```

Here are some other methods Python provides for working with integers and floats.

- `round()`: Rounds a number to the specified number of decimal places. By default this function rounds to the nearest integer, and returns a whole number with no decimal places:
    

```python
my_int_1 = 4.798
my_int_2 = 4.253

rounded_int_1 = round(my_int_1)
rounded_int_2 = round(my_int_2, 1)

print(rounded_int_1) # 5
print(rounded_int_2) # 4.3
```

- `abs()`: returns the absolute value of a number,
    

```python
num = -15

absolute_value = abs(num)
print(absolute_value) # 15
```

- `pow()`: raises a number to the power of another or performs modular exponentiation.
    

```python
result_1 = pow(2, 3)  # Equivalent to 2 ** 3
print(result_1)  # 8

result_2 = pow(2, 3, 5)  # (2 ** 3) % 5
print(result_2)  # 3
```

# --questions--

## --text--

What does the double slash (`//`) operator do in Python?

## --answers--

It divides two numbers and returns the greatest integer less than or equal to the result.

---

 It performs regular division and returns a float.

### --feedback--

This operator is used for a special kind of integer division.

---

It represents a comment in Python.

### --feedback--

This operator is used for a special kind of integer division.

---

It raises a number to the power of another.

### --feedback--

This operator is used for a special kind of integer division.

## --video-solution--

1

## --text--

Which statement correctly describes integers in Python?

## --answers--

Integers can only store positive whole numbers.

### --feedback--

Think about what integers represent, like whole values, not numbers with decimal points.

---

Integers are numbers with decimal points.

### --feedback--

Think about what integers represent, like whole values, not numbers with decimal points.

---

Integers are whole numbers without decimal points, either positive or negative.

---

Integers automatically convert to floats when performing division

### --feedback--

Think about what integers represent, like whole values, not numbers with decimal points.

## --video-solution--

3

## --text--

Which method returns the absolute value of a number?

## --answers--

`abs()`

---

`round()`

### --feedback--

Think about the method that always gives a non-negative result.

---

`sum()`

### --feedback--

Think about the method that always gives a non-negative result.

---

`max()`

### --feedback--

Think about the method that always gives a non-negative result.

## --video-solution--

1
