---
id: 67d1d96532bc095aee051657
title: What Is TypeScript, and Why Is It Used in the Industry?
challengeType: 19
dashedName: what-is-typescript-and-why-is-it-used-in-the-industry
---

# --description--

JavaScript is considered a dynamically-typed language. This means that variables can receive any values at run time - declaring a variable as a number does not prevent you from assigning it a string value later, and function parameters can be passed any value.

The challenge of a dynamically-typed language is that the lack of type safety can introduce errors if you are not careful. TypeScript extends the JavaScript language to include static typing, which helps catch those errors before you even deploy your code. But how does it work?

Consider this JavaScript function:

```js
const getRandomValue = (array) => {
  return array[Math.floor(Math.random() * array.length)];
}
```

Our `getRandomValue` function takes an array and returns a random value from that array. But because JavaScript does not validate types, there is nothing preventing you from calling the function with a number:

```js
console.log(getRandomValue(10));
```

The console output for the current example will return `undefined` because it was expecting an array instead of a number.

But with TypeScript you can define a type for the array parameter:

```js
const getRandomValue = (array: string[]) => {
  return array[Math.floor(Math.random() * array.length)];
}
```

This type definition tells TypeScript that the array argument must be an array of strings. Then when you call `getRandomValue` and pass it a number, you get a different type of error called a compiler error.

Most JavaScript runtime environments, such as a browser or Node.js, cannot run TypeScript natively. Instead, you first need to compile, or translate, TypeScript code into regular JavaScript. You can do that with the built-in compiler that comes with the TypeScript language. When you run the compiler, TypeScript will evaluate your code and throw an error for any issues where the types don't match - such as passing a number into a function that expects an array.

You'll learn more about how these types work in the next few lessons. But it's this extra safety that makes TypeScript an appealing language for many developers and organizations.

# --questions--

## --text--

What is the main advantage of TypeScript over JavaScript?

## --answers--

It runs faster in browsers.

### --feedback--

TypeScript extends JavaScript to include a feature that helps catch errors before deployment.

---

It provides static typing.

---

It has more built-in functions.

### --feedback--

TypeScript extends JavaScript to include a feature that helps catch errors before deployment.

---

It uses less memory.

### --feedback--

TypeScript extends JavaScript to include a feature that helps catch errors before deployment.

## --video-solution--

2

## --text--

In the TypeScript example, what does `array: string[]` indicate?

## --answers--

The function returns an array of strings.

### --feedback--

This syntax defines the type of the parameter passed to the function.

---

The function accepts an array of any type.

### --feedback--

This syntax defines the type of the parameter passed to the function.

---

The function accepts an array of strings.

---

The function can only work with strings.

### --feedback--

This syntax defines the type of the parameter passed to the function.

## --video-solution--

3

## --text--

What happens when you try to run TypeScript directly in most JavaScript environments?

## --answers--

It runs normally without any issues.

### --feedback--

TypeScript requires an additional step before it can be executed in typical JavaScript runtime environments.

---

It throws a compiler error.

### --feedback--

TypeScript requires an additional step before it can be executed in typical JavaScript runtime environments.

---

It automatically compiles to JavaScript.

### --feedback--

TypeScript requires an additional step before it can be executed in typical JavaScript runtime environments.

---

It cannot run.

## --video-solution--

4
