---
id: 672d49b2fb76df5f1d6117af
title: What Is String Concatenation, and How Can You Concatenate Strings with Variables?
challengeType: 19
dashedName: what-is-string-concatenation
---

# --interactive--

In JavaScript, working with text is an essential part of coding, and often, you'll need to combine or join pieces of text together. This process is called string concatenation.

In this lesson, we'll focus on how string concatenation works, specifically using the `+` operator, the `+=` operator, and the `concat()` method.

The `+` operator is one of the simplest and most frequently used methods to concatenate strings. It allows you to join multiple strings or combine strings with variables that hold text.

Here's an example:

:::interactive_editor

```js
let firstName = "John";
let lastName = "Doe";

let fullName = firstName + " " + lastName; 
console.log(fullName); // John Doe
```

:::

In this example, we used the `+` operator to concatenate the `firstName` and `lastName` variables along with a space (`" "`) to create the full name.

One disadvantage of using the `+` operator for string concatenation is that it can lead to spacing issues if you don't carefully manage the spacing between the concatenated strings.

Here is an example where a space is missing:

:::interactive_editor

```js
let firstName = "John";
let lastName = "Doe";

let fullName = firstName + lastName; 
console.log(fullName); // "JohnDoe"
```

:::

Whenever you use the `+` operator to concatenate strings, it is important to double check for any potential spacing issues.

If you need to add or append to an existing string, then you can use the `+=` operator. This is helpful when you want to build upon a string by adding more text to it over time.

Here's an example of appending one string to another using the `+=` operator:

:::interactive_editor

```js
let greeting = 'Hello';
greeting += ', John!';

console.log(greeting); // "Hello, John!"
```

:::

It is important to remember that strings are immutable which means once a string is created you can not alter it.

In this case, the original string of `Hello` is not modified. Instead, greeting now references the new string of `Hello, John!`

Another way you can concatenate strings is to use the `concat()` method.

Before we begin learning about the `concat()` method, it is important to first understand what a method and a function are at a higher level.

In programming, a function is a reusable block of code that performs a specific task and can be called with various inputs. A method, on the other hand, is a type of function that is associated with an object, meaning it operates on the data contained within that object.

In future lessons, we will dive much deeper into how functions, objects, and methods work in JavaScript. But for now, it is important to understand that JavaScript has dozens of methods you can use, like the `concat()` method.

Here's an example of using the `concat()` method to join two strings together:

:::interactive_editor

```js
let str1 = 'Hello';
let str2 = 'World';

let result = str1.concat(' ', str2); 
console.log(result); // Hello World
```

:::

In this example, we use the `concat()` method to join `str1`, a space (`' '`), and `str2` into a single string.

To conclude, `+` operator is best for simple concatenation, especially when you need to combine a few strings or variables.

The `+=` operator is useful when building up a string step by step or appending new content to an existing string variable.

Finally, the `concat()` method is beneficial when you need to concatenate multiple strings together.

# --questions--

## --text--

What is the primary use of the `+` operator in string concatenation?

## --answers--

To compare two strings.

### --feedback--

Think about how you combine text in JavaScript.

---

To join two or more strings together.

---

To check if two strings are equal.

### --feedback--

Think about how you combine text in JavaScript.

---

To remove characters from a string.

### --feedback--

Think about how you combine text in JavaScript.

## --video-solution--

2

## --text--

Which of the following is the correct way to concatenate strings?

## --answers--

```js
let greeting = "Hi";
greeting -= " there!";
```

### --feedback--

Refer back to the third example given in this lesson.

---

```js
let greeting = "Hi";
greeting =+ " there!";
```

### --feedback--

Refer back to the third example given in this lesson.

---

```js
let greeting = "Hi";
greeting += " there!";
```

---

```js
let greeting = "Hi";
greeting == " there!";
```

### --feedback--

Refer back to the third example given in this lesson.

## --video-solution--

3

## --text--

Which of the following is the correct method to concatenate multiple strings?


## --answers--

`concatenate()`

### --feedback--

Refer to the end of the lesson where this was discussed.

---

`concat()`

---

`concatenating()`

### --feedback--

Refer to the end of the lesson where this was discussed.

---

`concats()`

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

2
