---
id: 672d49a5cf43945ee09e5fba
title: What Is a String in JavaScript, and What Is String Immutability?
challengeType: 19
dashedName: what-is-a-string
---

# --interactive--

In JavaScript, a string is a sequence of characters used to represent text data. Strings are one of the primitive data types in the language, along with numbers, booleans, `null`, and `undefined`.

To create a string in JavaScript, you can use single quotes (`'`), or double quotes (`"`).

Here is an example of creating two variables that hold string values:

:::interactive_editor

```js
let singleQuotes = 'This is a string';
console.log(singleQuotes);
let doubleQuotes = "This is also a string";
console.log(doubleQuotes);
```

:::

Even though you can use single or double quotes to create strings, it's important to be consistent. If a string begins with a single quote, it must also end with a single quote.

The same applies to double quotes. The following example will throw an error because it starts with a double quote and ends with a single quote:

```js
const improperStr = "Do not do this';
```

Another thing to take into account is that strings are immutable. In programming, immutability means that once something is created, it cannot be changed. So, when you create a string, you can't change its characters directly. Instead, you would create a new string if you want to make changes.

Here is an example of assigning a new string to a `developer` variable:

:::interactive_editor

```js
let developer = "Jessica";
console.log(developer);
developer = "Quincy";
console.log(developer);
```

:::

Since strings are immutable, we can't update the first string directly. That is why we are assigning a new string to the `developer` variable.

Strings are an important part of programming, and in future lessons, you will learn advanced techniques for manipulating them and harnessing their full potential to create dynamic and interactive applications.

# --questions--

## --text--

Which of the following is the correct syntax for creating strings in JavaScript?

## --answers--

`const str = <this is a string>`

### --feedback--

Review the examples given in the lesson.

---

`const str = [this is a string]`

### --feedback--

Review the examples given in the lesson.

---

`const str = "this is a string"`

---

`const str = //this is a string//`

### --feedback--

Review the examples given in the lesson.

## --video-solution--

3

## --text--

What happens if a string starts with a single quote and ends with a double quote?

## --answers--

It creates a valid string.

### --feedback--

Think about the requirement for matching quotes.

---

It will throw a syntax error.

---

It creates a string with both quotes.

### --feedback--

Think about the requirement for matching quotes.

---

It will be ignored by the JavaScript interpreter.

### --feedback--

Think about the requirement for matching quotes.

## --video-solution--

2

## --text--

Why are strings considered immutable in JavaScript?

## --answers--

You cannot create strings using variables.

### --feedback--

Consider what "immutable" means in programming.

---

Once a string is created, you cannot change its characters directly.

---

Strings can only be created using literals.

### --feedback--

Consider what "immutable" means in programming.

---

You can change strings, but only through global variables.

### --feedback--

Consider what "immutable" means in programming.

## --video-solution--

2
