---
id: 67fe8567f141d632afaeb71b
title: How Do You Install, Configure and Use Python in Your Local Environment?
challengeType: 19
dashedName: how-do-you-install-configure-and-use-python-in-your-local-environment
---

# --description--

In the last lesson, you learned what Python is and what you can do with it. Now, let's look into how you can set up Python on your local machine.

The easiest way to install Python on Windows and Mac is to download the installer from the official Python website. We'll also go over running Python on Linux later in this lesson.

Go to `https://www.python.org/` and hover over "Downloads". A modal will appear showing the current version of Python for your operating system (OS).

We'll go over how to install Python on a computer running macOS first:

- Click on the button showing the current version of Python (from the previous modal), and you'll start downloading a `.pkg` installation file automatically.
- Once the `.pkg` installer is finished downloading, open it, then click "Continue" in the window that opens up.
- Continue clicking the "Continue" button until you get to the "Installation Type" section. There, click the "Install" button.
- Enter your password if necessary, then start the installation.
- After that, you should get a congratulations message saying that Python has been successfully installed.
- Click the "Close" button, and you're done!

You can verify the installation by opening up your terminal and running `python --version` or `python3 --version`.

You can also open the Python interpreter by running `python` or `python3` in the terminal.

A <dfn>terminal</dfn> is a text-based interface that lets you interact with your computer by typing commands. Each operating system comes with a default terminal app. On macOS, you can use the Terminal app. On Windows, you can use Command Prompt or PowerShell. On Linux, each desktop environment has its own default terminal app, like GNOME Terminal or Konsole.

Note that, on some older macOS and Linux systems, `python` can be reserved for Python 2, while `python3` is for Python 3 specifically. If you run `python --version` and see a version of Python 2 like `Python 2.7.18`, then it's possible that your OS relies on some software that was written in the older version of Python. If that's the case, you should use `python3` to run your Python code going forward. Python 2 is end-of-life and should not be used for any new development.

To install Python on Windows, follow these steps:

- Go to `https://www.python.org/`, and hover over “Downloads“. You should see a modal that says "Download for Windows" and a download button with the current version of Python.
- Click on the version number, and you'll start downloading a Windows executable (`.exe`) file automatically.
- Once you've finished downloading the Python installer for Windows, double-click on it, and follow the instructions.
- When you see the option `Add python.exe to Path`, check that option, then click `Install Now`. Doing that will make things easier for you later.


You can verify the installation by opening up a command line shell like PowerShell and running `python --version`. You can also open the Python interpreter by running `python`.

For Python on Linux, most major distros like Ubuntu, Debian, and Fedora come with Python.

Just open a terminal and run `python --version`, or `python3 --version`:

If either command doesn't show a version of Python, you can search for an installation package for your flavor of Linux at `https://www.python.org`, or search online for the recommended way to install Python for your distro.

# --questions--

## --text--

Which address can you download Python from?

## --answers--

`wikipedia.org`

### --feedback--

Think about the official Python website.

---

`python3.com`

### --feedback--

Think about the official Python website.

---

`python3.org`

### --feedback--

Think about the official Python website.

---

`python.org`

## --video-solution--

4

## --text--

How can you get Python added to `path` automatically on Windows?

## --answers--

By installing Python.

### --feedback--

Review the last part of the lesson.

---

By checking the "add to path" checkbox during the installation process.

---

By checking the "use admin privileges" checkbox.

### --feedback--

Review the last part of the lesson.

---

By downloading Python from `python.org`.

### --feedback--

Review the last part of the lesson.

## --video-solution--

2

## --text--

What kind of file do you download while installing Python for Windows?

## --answers--

A package file (`.pkg`)

### --feedback--

Think about the extension of the file that you download when you want to install Python.

---

An AVI file.

### --feedback--

Think about the extension of the file that you download when you want to install Python.

---

An executable (`.exe`)

---

An executable JSON file

### --feedback--

Think about the extension of the file that you download when you want to install Python.

## --video-solution--

3
