---
id: 6839b2ddd01ef657b6bf3b76
title: What Are Some Common String Methods?
challengeType: 19
dashedName: what-are-some-common-string-methods
---

# --description--

Python provides a number of built-in methods that make working with strings a breeze. They include, but are not limited to, the following:

- `upper()`: Returns a new string with all characters converted to uppercase.
    

```python
my_str = 'hello world'

uppercase_my_str = my_str.upper()
print(uppercase_my_str)  # HELLO WORLD
```

- `lower()`: Returns a new string with all characters converted to lowercase.
    

```python
my_str = 'Hello World'

lowercase_my_str = my_str.lower()
print(lowercase_my_str)  # hello world
```

- `strip()`: Returns a new string with the specified leading and trailing characters removed. If no argument is passed it removes leading and trailing whitespace.
    

```python
my_str = '  hello world  '

trimmed_my_str = my_str.strip()
print(trimmed_my_str)  # "hello world"
```

- `replace(old, new)`: Returns a new string with all occurrences of `old` replaced by `new`.
    

```python
my_str = 'hello world'

replaced_my_str = my_str.replace('hello', 'hi')
print(replaced_my_str)  # hi world
```

- `split(separator)`: Splits a string on a specified separator into a list of strings. If no separator is specified, it splits on whitespace.
    

```python
my_str = 'hello world'

split_words = my_str.split()
print(split_words)  # ['hello', 'world']
```

- `join(iterable)`: Joins elements of an iterable into a string with a separator.
    

```python
my_list = ['hello', 'world']

joined_my_str = ' '.join(my_list)
print(joined_my_str)  # hello world
```

- `startswith(prefix)`: Returns a boolean indicating if a string starts with the specified prefix.
    

```python
my_str = 'hello world'

starts_with_hello = my_str.startswith('hello')
print(starts_with_hello)  # True
```

- `endswith(suffix)`: Returns a boolean indicating if a string ends with the specified suffix.
    

```python
my_str = 'hello world'

ends_with_world = my_str.endswith('world')
print(ends_with_world)  # True
```

- `find(substring)`: Returns the index of the first occurrence of `substring`, or `-1` if it doesn't find one.
    

```python
my_str = 'hello world'

world_index = my_str.find('world')
print(world_index)  # 6
```

- `count(substring)`: Returns the number of times a substring appears in a string.
    

```python
my_str = 'hello world'

o_count = my_str.count('o')
print(o_count)  # 2
```

- `capitalize()`: Returns a new string with the first character capitalized and the other characters lowercased.
    

```python
my_str = 'hello world'

capitalized_my_str = my_str.capitalize()
print(capitalized_my_str)  # Hello world
```

- `isupper()`: Returns `True` if all letters in the string are uppercase and `False` if not.
    

```python
my_str = 'hello world'

is_all_upper = my_str.isupper()
print(is_all_upper)  # False
```

- `islower()`: Returns `True` if all letters in the string are lowercase and `False` if not.
    

```python
my_str = 'hello world'

is_all_lower = my_str.islower()
print(is_all_lower)  # True
```

- `title()`: Returns a new string with the first letter of each word capitalized.
    

```python
my_str = 'hello world'

title_case_my_str = my_str.title()
print(title_case_my_str)  # Hello World
```

# --questions--

## --text--

Which methods check if all letters in a string are uppercase and if all letters are lowercase?

## --answers--

`upper()` and `lower()`

### --feedback--

These methods return `True` or `False` based on letter case.

---

`isupper()` and `islower()`

---

`toupper()` and `tolower()`

### --feedback--

These methods return `True` or `False` based on letter case.

---

`uppercase()` and `lowercase()`

### --feedback--

These methods return `True` or `False` based on letter case.

## --video-solution--

2

## --text--

How can you replace all occurrences of one or more parts of a string with another string?

## --answers--

Using the `change()` method with two arguments.

### --feedback--

The method takes two arguments - what to find and what to replace it with.

---

Using the `replace()` method with old and new text.

---

Using the `modify()` function with replacement rules.

### --feedback--

The method takes two arguments - what to find and what to replace it with.

---

Using the `update()` method with a mapping dictionary.

### --feedback--

The method takes two arguments - what to find and what to replace it with.

## --video-solution--

2

## --text--

What does the `upper()` method do?

## --answers--

Converts all characters to lowercase.

### --feedback--

It changes the case but doesn't modify spacing.

---

Capitalizes only the first letter.

### --feedback--

 It changes the case but doesn't modify spacing.

---

Converts all characters to uppercase.

---

Removes all whitespace.

### --feedback--

 It changes the case but doesn't modify spacing.

## --video-solution--

3
