---
id: 6732b749b8aad125523dcda5
title: What Is the Difference Between Functions and Object Methods?
challengeType: 19
dashedName: what-is-the-difference-between-functions-and-object-methods
---

# --interactive--

In JavaScript, functions and object methods are both ways to encapsulate reusable code, but they have some key differences in how they are defined, used, and the context in which they operate. Understanding these differences is crucial for writing effective and organized JavaScript code.

As you learned in earlier modules, functions are reusable blocks of code that perform a specific task:

:::interactive_editor

```js
function greet(name) {
    return "Hello, " + name + "!";
}
console.log(greet("Alice")); // "Hello, Alice!"
```

:::

Object methods, on the other hand, are functions that are associated with an object. They are defined as properties of an object and can access and manipulate the object's data. Here's an example of an object with a method:

:::interactive_editor

```js
const person = {
    name: "Bob",
    age: 30,
    sayHello: function() {
        return "Hello, my name is " + this.name;
    }
};

console.log(person.sayHello()); // "Hello, my name is Bob"
```

:::

In this example, `sayHello` is a method of the `person` object. The `this` keyword allows the `sayHello` method to access the properties of the object named `person`. You will learn more about the `this` keyword in future lessons.

A difference between functions and methods is how they are invoked. Functions are called by their name, while methods are called using dot notation on the object they belong to. For example, we call the `greet` function as `greet("Alice")`, but we call the `sayHello` method as `person.sayHello()`.

Another important difference is the context in which they operate. Regular functions have their own scope, but they don't have a built-in reference to any particular object. Methods, however, are bound to their object and can access its properties and other methods using the `this` keyword.

A key point to note is that, methods help in organizing code into logical objects, while functions are used for more general, reusable code.

Understanding the difference between functions and object methods is important as you progress in your JavaScript journey. While they may seem similar at first, recognizing when to use each will help you write more organized, efficient, and better code.

# --questions--

## --text--

What is the main difference between a function and an object method?

## --answers--

Functions can take parameters, but methods cannot.

### --feedback--

Consider how functions and methods are defined and their relationship to objects.

---

Methods are associated with objects, while functions are standalone.

---

Functions can return values, but methods cannot.

### --feedback--

Consider how functions and methods are defined and their relationship to objects.

---

Methods can use the `this` keyword, but functions cannot.

### --feedback--

Consider how functions and methods are defined and their relationship to objects.

## --video-solution--

2

## --text--

Given the following code, how would you correctly call the `greet` method?

```js
let person = {
    name: "Alice",
    greet: function() {
        console.log("Hello, I'm " + this.name);
    }
};
```

## --answers--

`greet();`

### --feedback--

Remember how methods are called on objects using dot notation.

---

`person.greet;`

### --feedback--

Remember how methods are called on objects using dot notation.

---

`person.greet();`

---

`person(greet);`

### --feedback--

Remember how methods are called on objects using dot notation.

## --video-solution--

3

## --text--

What will be the output of the following code?

```js
function sayHello() {
    return "Hello!";
}

let obj = {
    sayHello: function() {
        return "Hi there!";
    }
};

console.log(sayHello());
console.log(obj.sayHello());
```

## --answers--

`"Hello!", "Hello!"`

### --feedback--

Consider that the function and the method have the same name but are defined and called differently.

---

`"Hi there!", "Hi there!"`

### --feedback--

Consider that the function and the method have the same name but are defined and called differently.

---

`"Hello!", "Hi there!"`

---

This will throw an error.

### --feedback--

Consider that the function and the method have the same name but are defined and called differently.

## --video-solution--

3
