---
id: 6732b73d25cc01251b778043
title: What Is the Difference Between Primitive and Non-Primitive Data Types?
challengeType: 19
dashedName: what-is-the-difference-between-primitive-and-non-primitive-data-types
---

# --interactive--

In JavaScript, understanding the difference between primitive and non-primitive data types is important for writing efficient and bug-free code. 

These two categories of data types behave differently in terms of how they are stored in memory and how they are manipulated in your programs.

Primitive data types are the simplest form of data in JavaScript. They include numbers, strings, booleans, `null`, `undefined`, and symbols. These types are called "primitive" because they represent single values and are not objects. 

When you work with primitive data types, you're dealing directly with their values. For example, when you create a variable with a primitive value, that value is stored directly in the variable. 

Primitive values are immutable, which means once they are created, their value cannot be changed. However, you can reassign a new value to the variable. Here's an example of working with primitive data types:

:::interactive_editor

```js
let num1 = 5;
let num2 = num1;
num1 = 10;

console.log(num2); // 5
```

:::

In this example, we are assigning a primitive value (`5`) from `num1` to `num2`. This creates an independent copy of the value. As a result, any changes made to the original variable (`num1`) do not affect the copy (`num2`).

Non-primitive data types, on the other hand, are more complex. In JavaScript, these are objects, which include regular objects, arrays, and functions. Unlike primitives, non-primitive types can hold multiple values as properties or elements. 

When you create a variable with a non-primitive value, what's stored in the variable is actually a reference to the location in memory where the object is stored, not the object itself. This leads to some important differences in behavior. Here's an example with non-primitive types:

:::interactive_editor

```js
const originalPerson = { name: "John", age: 30 };
const copiedPerson = originalPerson;

originalPerson.age = 31;

console.log(copiedPerson.age); // 31
```

:::

In this example we have an object called `originalPerson` with two properties of `name` and `age`. We then assign the `originalPerson` object to a variable called `copiedPerson`.

Then we update the `age` value for the `originalPerson` object. When we log the `age` property of `copiedPerson` object it shows the updated value.

But why is that happening? This occurs because both `originalPerson` and `copiedPerson` are referencing the same object in memory.

In JavaScript, when you assign an object to another variable, you're copying the reference to the object, not the object itself. This is known as shallow copying by reference. As a result, any changes made to the object through one reference are reflected in all references to that object.

As you continue to work with JavaScript, you'll encounter many situations where understanding the difference between primitive and non-primitive types is important. It's a fundamental concept that underlies many aspects of the language and is key to writing efficient and correct code.

# --questions--

## --text--


Which of the following is NOT a primitive data type in JavaScript?

## --answers--

`Number`

### --feedback--

Think about which data type can hold multiple values.

---

`String`

### --feedback--

Think about which data type can hold multiple values.

---

`Boolean`

### --feedback--

Think about which data type can hold multiple values.

---

`Array`

## --video-solution--

4

## --text--

What happens when you assign a primitive value to a new variable?

## --answers--

The new variable gets a reference to the original value.

### --feedback--

Remember how we said primitive values are stored and copied.

---

The value is copied to the new variable.

---

Both variables share the same memory location.

### --feedback--

Remember how we said primitive values are stored and copied.

---

The original variable becomes `null`.

### --feedback--

Remember how we said primitive values are stored and copied.

## --video-solution--

2

## --text--

What will be the output of the following code?

```js
let x = 10;
let y = x;
x = 20;
console.log(y);
```

## --answers--

`10`

---

`20`

### --feedback--

Remember how primitive data types are copied when assigned to a new variable.

---

`undefined`

### --feedback--

Remember how primitive data types are copied when assigned to a new variable.

---

This will throw an error.

### --feedback--

Remember how primitive data types are copied when assigned to a new variable.

## --video-solution--

1
