---
id: 6732b72961f94324bd6390de
title: How to Check If an Object Has a Property?
challengeType: 19
dashedName: how-to-check-if-an-object-has-a-property
---

# --interactive--

In JavaScript, there are several ways to check if an object has a specific property. Understanding these methods is important for working effectively with objects, especially when you're dealing with data from external sources or when you need to ensure certain properties exist before using them. 

We'll explore three common approaches: the `hasOwnProperty()` method, the `in` operator, and checking against `undefined`.

Let's start with the `hasOwnProperty()` method. This method returns a boolean indicating whether the object has the specified property as its own property. Here's an example:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30
};

console.log(person.hasOwnProperty("name")); // true
console.log(person.hasOwnProperty("job")); // false
```

:::

In this example, we have an object called `person` with two properties: `name` and `age`. To check if `name` is a property in the `person` object, we use the `hasOwnProperty()` method. Since `name` is a property, it will return `true`. But when we use the `hasOwnProperty()` to check if `job` is a property, it will return `false` because it does not exist in the object.

Another way to check for the existence of a property in an object is to use the `in` operator. Like `hasOwnProperty()`, the `in` operator will return `true` if the property exists on the object. Here's how you can use it:

:::interactive_editor

```js
const person = {
  name: "Bob",
  age: 25
};
console.log("name" in person);  // true
```

:::

In this example, `"name" in person` returns `true` because `name` is a property of `person`.

The third method involves checking if a property is `undefined`. This approach can be useful, but it has some limitations. Here's an example:

:::interactive_editor

```js
const car = {
  brand: "Toyota",
  model: "Corolla",
  year: 2020
};

console.log(car.brand !== undefined); // true
console.log(car.color !== undefined); // false
```

:::

In this code, we check if `car.brand` and `car.color` are not `undefined`. This works because accessing a non-existent property on an object returns `undefined`. However, this method can give false negatives if a property explicitly has the value `undefined`.

In practice, the choice between these methods often depends on the specific requirements of your code. Understanding the differences between them will help you make the right choice in different scenarios.

# --questions--

## --text--

What will be the output of the following code?

```js
let obj = {x: 0, y: null};
console.log(obj.hasOwnProperty("y"));
```

## --answers--

`true`

---

`false`

### --feedback--

`hasOwnProperty()` checks if the property exists directly on the object, regardless of its value.

---

`null`

### --feedback--

`hasOwnProperty()` checks if the property exists directly on the object, regardless of its value.

---

`undefined`

### --feedback--

`hasOwnProperty()` checks if the property exists directly on the object, regardless of its value.

## --video-solution--

1

## --text--

What will be the output of the following code?

```js
let person = {
    name: "Alice",
    age: 30
};

console.log("name" in person);
```

## --answers--

`true`

---

`false`

### --feedback--

The `in` operator checks if the property exists in the object.

---

`"Alice"`

### --feedback--

The `in` operator checks if the property exists in the object.

---

`undefined`

### --feedback--

The `in` operator checks if the property exists in the object.

## --video-solution--

1

## --text--

What will be the output of the following code?

```js
let obj = {a: undefined};
console.log(obj.a !== undefined);
```

## --answers--

`true`

### --feedback--

Consider what happens when a property exists but has the value `undefined`.

---

`false`

---

`undefined`

### --feedback--

Consider what happens when a property exists but has the value `undefined`.

---

This will throw an error.

### --feedback--

Consider what happens when a property exists but has the value `undefined`.

## --video-solution--

2
