---
id: 6732b721eb98f224868b44a6
title: How Can You Remove Properties from an Object?
challengeType: 19
dashedName: how-can-you-remove-properties-from-an-object
---

# --interactive--

There are several ways to remove properties from an object, with the `delete` operator being the most straightforward and commonly used method.

When you use `delete`, it removes the selected property from the object. Here's an example of how to use the `delete` operator:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  job: "Engineer"
};

delete person.job;

console.log(person.job); // undefined
```

:::

In this example, we start with a `person` object that has three properties: `name`, `age`, and `job`. Then, we use the `delete` operator to remove the `job` property. After the deletion, the `person` object no longer has the `job` property.

Another way to remove properties is by using destructuring assignment with rest parameters. This approach doesn't actually delete the property, but it creates a new object without the specified properties:

:::interactive_editor

```js
const person = {
  name: "Bob",
  age: 25,
  job: "Designer",
  city: "New York"
};

const { job, city, ...remainingProperties } = person;

// { name: "Bob", age: 25 }
console.log(remainingProperties);
```

:::

In this example, we use destructuring to extract `job` and `city` from the `person` object, and collect the remaining properties into a new object called `remainingProperties`. This creates a new object without the `job` and `city` properties.

Understanding how to remove properties from objects is an important skill in JavaScript programming. It allows you to manipulate objects dynamically, and clean up unnecessary data.

# --questions--

## --text--

What will be the output of the following code?

```js
let obj = {a: 1, b: 2, c: 3};
delete obj.b;
console.log(obj);
```

## --answers--

`{a: 1, c: 3}`

---

`{a: 1, b: undefined, c: 3}`

### --feedback--

Consider how the `delete` operator affects object properties.

---

`{a: 1, b: 2, c: 3}`

### --feedback--

Consider how the `delete` operator affects object properties.

---

This will throw an error.

### --feedback--

Consider how the `delete` operator affects object properties.

## --video-solution--

1

## --text--

What will be the output of the following code?

```js
let car = {
    brand: "Toyota",
    model: "Corolla",
    year: 2020
};

delete car.year;
console.log(car.year);
```

## --answers--

`2020`

### --feedback--

Think about what happens when you try to access a property that has been deleted.

---

`undefined`

---

`null`

### --feedback--

Think about what happens when you try to access a property that has been deleted.

---

This will throw an error.

### --feedback--

Think about what happens when you try to access a property that has been deleted.

## --video-solution--

2

## --text--

Which operator is commonly used to remove properties from an object in JavaScript?

## --answers--

`remove`

### --feedback--

Consider the standard JavaScript operator for removing object properties.

---

`delete`

---

`erase`

### --feedback--

Consider the standard JavaScript operator for removing object properties.

---

`clear`

### --feedback--

Consider the standard JavaScript operator for removing object properties.

## --video-solution--

2
