---
id: 6734e88cc46e6dc679420040
title: What is Vite, and How Can It Be Used to Set Up a New React Project?
challengeType: 19
dashedName: what-is-vite-and-how-can-it-be-used-to-set-up-a-new-react-project
---

# --description--

Unlike working with smaller vanilla HTML, CSS, and JavaScript projects, starting a new React project includes a few more steps to ensure that everything runs correctly. Instead of trying to set up of all of the necessary configurations by yourself, there are tools that will do that for you. 

One of the most popular tools for setting up projects is Vite. Vite, which means "fast" in French, is a build tool that aims to provide a faster development experience for modern web projects. Vite can be used with React, as well as with other libraries and frameworks like Vue or Svelte. You can even use it with vanilla JavaScript projects.

To create a new project with Vite, you will need to use the command line. If you are using Windows machine, then you can use the Command Prompt or Windows PowerShell. If you are using a Mac, then you can use the Terminal app.

Once you have the command line open, you can use the following command:

```bash
npm create vite@latest my-react-app -- --template react
```

This command creates a new React project named `my-react-app` using Vite's React template.

You can then open up the new project and see the React boilerplate code that Vite has provided for you.

The great thing about Vite is that it will only provide the files that are absolutely necessary to get started with your React project.

To actually run the project as-is, you will need to install the dependencies using the following commands in the command line:

```bash
cd my-react-app
npm install
```

The `cd my-react-app` command ensures that you change to the correct directory where your project is located.

The `npm install` command is used to install the dependencies needed to properly run your React project. Dependencies are libraries or packages that your React project requires in order to function correctly, such as React itself, ReactDOM, or other third-party packages that provide additional functionality.

Running `npm install` will read the `package.json` file in your project directory and install all the dependencies listed there, allowing you to build and run your React app without missing any necessary components.

The `package.json` file is a key configuration file in projects that contains metadata about your project, including its name, version, and dependencies. It also defines scripts, licensing information, and other settings that help manage the project and its dependencies.

Once the dependencies are installed, you should notice a new folder in your project called `node_modules`.

The `node_modules` folder is where all the packages and libraries required by your project are stored. This folder contains the actual code for the dependencies listed in your `package.json` file, including both your project's direct dependencies and any dependencies of those dependencies.

To run your project, run the `npm run dev` command and open up a new browser tab at `http://localhost:5173/`.

You should see the starter template that Vite has provided for you.

If you need to stop the local server, press `CTRL + C` in the command line.

To actually see the code for this starter template, you can go into your project inside the `src` folder and you should see the `App.jsx` file.

From there you can start to modify the file, save your changes and see the new changes display in the browser.

And with that, you're ready to begin building your React application!

# --questions--

## --text--

What is the main advantage of using Vite when starting a new React project?

## --answers--

It automatically writes the main application logic for you.

### --feedback--

Think about the speed difference between setting up a project on your own versus using Vite.

---

It provides a faster development experience by automating configurations and build processes.

---

It spots all security vulnerabilities in your React project.

### --feedback--

Think about the speed difference between setting up a project on your own versus using Vite.

---

It installs external libraries like jQuery and Bootstrap.

### --feedback--

Think about the speed difference between setting up a project on your own versus using Vite.

## --video-solution--

2

## --text--

What does the `npm install` command do after creating a new React project with Vite?

## --answers--

It starts the development server.

### --feedback--

Consider what needs to happen before you can run the project.

---

It installs the dependencies listed in the `package.json` file.

---

It opens the project in the browser.

### --feedback--

Consider what needs to happen before you can run the project.

---

It creates the `App.jsx` file.

### --feedback--

Consider what needs to happen before you can run the project.

## --video-solution--

2

## --text--

Which directory contains the starting code that is found in the `App.jsx` file?

## --answers--

`home`

### --feedback--

Review the end section where this was discussed.

---

`index`

### --feedback--

Review the end section where this was discussed.

---

`src`

---

`public`

### --feedback--

Review the end section where this was discussed.

## --video-solution--

3
