---
id: 6734e3a9cc78faaf4248d335
title: What Is the Role of JS Libraries and Frameworks, and Why Are They Used in the Industry?
challengeType: 19
dashedName: what-is-the-role-of-js-libraries-and-frameworks-and-why-are-they-used-in-the-industry
---

# --description--

JavaScript libraries and frameworks provide pre-built code that streamlines the development process.  While both libraries and frameworks serve to improve productivity and standardize coding practices, they differ in their approach and level of control they provide to developers.

Libraries are generally more focused on providing solutions to specific tasks, such as manipulating the DOM, handling events, or managing AJAX requests.

An example of a JavaScript library is jQuery.

jQuery became very popular in the early 2010s and was widely used to simplify DOM manipulation, event handling, animations, effects, and more. This library also offered a rich ecosystem of plugins, which made it easy to build common web components like date pickers, sliders, and modal dialogs.

Although jQuery is no longer as widely used as it once was, it significantly helped developers by making tasks that were complex in vanilla JavaScript much easier to implement.

Frameworks, on the other hand, provide a more defined structure for building applications. They often come with a set of rules and conventions that developers need to follow.

For example, Angular encourages a component-based architecture with a set of conventions and tools that provide a structured approach to organizing and building applications. Angular gives developers clear guidelines on how to structure components, manage state, handle routing, and interact with services, making it a more opinionated framework.

Other examples of frameworks include Remix and Next.js.

In contrast, React, a UI library, is more flexible and doesn't enforce any particular architectural pattern. React focuses primarily on the view layer and leaves a lot of the choices on application design up to the developers.

Although libraries and frameworks are used across projects of all sizes, the choice between using them often depends on the project's requirements. Libraries offer flexibility for specific functionalities, while frameworks provide a structured approach towards complex applications.

In the industry, libraries and frameworks are widely used for several reasons. They significantly speed up development by providing quick solutions for common problems.

One common problem in JavaScript is working with dates and timezones. But there are libraries out there with built-in solutions to help you with date manipulation, time zones, parsing and formatting of dates.

A lot of popular libraries and frameworks are well-tested and maintained by large communities. This means they're often more practical than building the same thing from scratch.

Libraries and frameworks follow best practices and patterns that have been proven effective in real life scenarios. This can lead to more robust and scalable applications.

In conclusion, libraries and frameworks offer quick solutions to common problems, speed up development, and promote best practices. Understanding the differences between libraries and frameworks, and knowing when to use them is a valuable skill for any JavaScript developer.

# --questions--

## --text--

Why was jQuery a popular library of choice in the early 2010's?

## --answers--

jQuery was used to simplify things like DOM manipulation, event handling, animations and effects.

---

jQuery was never popular.

### --feedback--

Think about how this library helped to simplify the development process.

---

jQuery made your code run 10x faster.

### --feedback--

Think about how this library helped to simplify the development process.

---

jQuery allowed you to write 100% bug free code.

### --feedback--

Think about how this library helped to simplify the development process.

## --video-solution--

1

## --text--

Which of the following is an example of a JavaScript library?

## --answers--

COBOL

### --feedback--

Review the beginning section where React libraries were first discussed.

---

React

---

Ruby on Rails

### --feedback--

Review the beginning section where React libraries were first discussed.

---

Swift

### --feedback--

Review the beginning section where React libraries were first discussed.

## --video-solution--

2

## --text--

Why are JavaScript libraries and frameworks widely used in the industry?

## --answers--

They make websites look more attractive.

### --feedback--

Think about the benefits libraries and frameworks provide to developers and businesses.

---

They speed up development and promote best practices.

---

They are required by web browsers.

### --feedback--

Think about the benefits libraries and frameworks provide to developers and businesses.

---

They automatically fix all bugs in code.

### --feedback--

Think about the benefits libraries and frameworks provide to developers and businesses.

## --video-solution--

2
