---
id: 672a54bc58319c8fe6f78ad4
title: What Is the aria-hidden Attribute, and How Does It Work?
challengeType: 19
dashedName: what-is-the-aria-hidden-attribute
---

# --interactive--

If you ever need to display content while at the same time hiding it from people who use assistive technology, like screen readers, you can use the `aria-hidden` attribute.

You just need to add it to the HTML element that you want to hide and set its value to `true`, like you can see over here: `aria-hidden="true"`.

This attribute hides the element and all of its children from the accessibility tree, while keeping them visible on the page. Common use cases include:

- Icons and images that only have a decorative purpose.
- Duplicated content.

It is important to remember that `aria-hidden` only hides content from assistive technology, such as screen readers. If the content should be hidden from everyone, then you should not use `aria-hidden` to hide it. For example, a hamburger menu that is currently collapsed must be hidden from all keyboard users, not just screen reader users. In this case you could set the CSS `display` property to `none` on the menu to remove it from the DOM when it is collapsed.

You should never use `aria-hidden` to hide an element that is focusable with the keyboard. The `aria-hidden` attribute only removes the element from the accessibility tree. It does not remove it from the DOM. Thus, it will still be possible for screen reader users to tab to the element, but their screen reader will not announce the element, effectively causing them to focus on "nothing".

Here's an example where we hide an icon from the accessibility tree by adding the `aria-hidden` attribute with a value of `true`. 

We only keep the text exposed to assistive technologies to avoid any confusion that may arise from the redundancy of having both an icon and text for the same purpose.

**NOTE**: This interactive example includes the Font Awesome CDN so you can see the gear icon displayed in the preview window. To see the previews, you will need to enable the interactive editor.

:::interactive_editor

```html
<head>
  <!-- Font Awesome CDN -->
  <link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.5.0/css/all.min.css"
  />
</head>

<button>
  <i class="fa-solid fa-gear" aria-hidden="true"></i>
  <span class="label">Settings</span>
</button>
```

:::

You do not need to use `aria-hidden` when:

- The HTML element already has a `hidden` attribute.
- The element or the element's ancestor is already hidden with `display: none`.
- The element or the element's ancestor is already hidden with `visibility: hidden`.

In these three cases, the element is already removed from the DOM and thus hidden from the accessibility tree, so the `aria-hidden` attribute is not necessary.

As with using any ARIA attributes, you should always test with assistive technologies, and preferably having people with disabilities test your work, to make sure that it's easy to understand, even with these hidden elements.

You should also know that setting `aria-hidden` to `false` will not expose the element to assistive technologies if any of its parents has this attribute set to `true`.

The `aria-hidden` attribute is used to hide elements from people who use assistive technology, such as screen reader users.

While it can be helpful for hiding purely decorative elements and duplicated content, it should be used sparingly to avoid hindering accessibility.

In general, all content and functionality available on the page should also be available to people using assistive technology. The use case for `aria-hidden` is very narrow and should be limited primarily to making the experience cleaner for screen reader users by removing purely decorative or duplicate information. Do not use `aria-hidden` to hide content that you don’t think screen reader users would be interested in. Screen reader users deserve to have access to all information on the page.

By following these best practices and testing the user experience, you can create inclusive online experiences for everyone.

# --questions--

## --text--

What is the primary purpose of the `aria-hidden` attribute?

## --answers--

To define the visual appearance of an element.

### --feedback--

Think about how `aria-hidden` affects the accessibility of elements.

---

To improve website performance.

### --feedback--

Think about how `aria-hidden` affects the accessibility of elements.

---

To hide elements from assistive technologies.

---

To enhance browser compatibility.

### --feedback--

Think about how `aria-hidden` affects the accessibility of elements.

## --video-solution--

3

## --text--

When should the `aria-hidden` attribute be used?

## --answers--

For all elements on a web page.

### --feedback--

Think about the purpose of `aria-hidden` and when it's appropriate to use it.

---

For elements that are visually hidden but still important for the user experience.

### --feedback--

Think about the purpose of `aria-hidden` and when it's appropriate to use it.

---

For decorative elements that do not contribute to the main content.

---

For elements that are dynamically added or removed.

### --feedback--

Think about the purpose of `aria-hidden` and when it's appropriate to use it.

## --video-solution--

3

## --text--

What are the potential risks of overusing the `aria-hidden` attribute?

## --answers--

Reduced website performance.

### --feedback--

Think about how hiding elements can affect the user experience.

---

Incompatibility with older browsers.

### --feedback--

Think about how hiding elements can affect the user experience.

---

Hindered accessibility for users with disabilities.

---

Increased file size.

### --feedback--

Think about how hiding elements can affect the user experience.

## --video-solution--

3
