---
id: 672990ecf71a852804ababe7
title: What Is the Difference Between Presentational and Semantic HTML?
challengeType: 19
dashedName: what-is-the-difference-between-presentational-and-semantic-html
---

# --interactive--

Presentational HTML focuses on the appearance and style of the content. In the early days of HTML, developers would use elements like the `center`, `big`, and `font` elements. But in modern web development you shouldn't use these types of elements, because of their limitations and negative impact on accessibility and maintainability.

Many presentational HTML elements are deprecated, which means that they are outdated and no longer recommended. There are better ways to get the same results. However, it is helpful to know that they exist, so we'll take a look at some examples.

The `font` element is a deprecated element used to set the font size and color of the text. Here's an example of a `font` element.

Enable the interactive editor and change the size from 5 to 7 to see the font increase.

:::interactive_editor

```html
<font size="5" color="blue">This text is blue and large.</font>
```

:::

This example sets the color of the text to `blue` and the size to a value of `5`. The range for the `size` attribute is from `1` to `7`, with `1` being the smallest and `7` being the largest. The default value is `3`, if you don't set the value explicitly.

While this element still works, you should not use it because the font size and color should always be set in CSS, not in HTML. 

The `center` element is another deprecated element that is used to center the content horizontally within its container. Here's an example of the `center` element that contains text and a paragraph element.

Enable the interactive editor and add `center` tags around the `<p>Another example text.</p>` to see it centered on the page.

:::interactive_editor

```html
<center>
  This text is centered.
  <p>HTML is awesome.</p>
</center>

<p>Another example text.</p>
```

:::

And next, we have the `big` element. This is another deprecated presentational HTML element that makes the enclosed text one level bigger than its surrounding text. Here we have an example that defines a paragraph with two parts.

Enable the interactive editor and add `big` tags around the `Some other text` and see the changes in the preview window. 

:::interactive_editor

```html
<p>
  This text has a normal font size.
  <big>This text is larger.</big>
  Some other text.
</p>
```

:::

Remember that font size should always be set with CSS, so you should not use this element in modern HTML.

These were examples of presentational HTML elements. But all of them are deprecated and no longer recommended. So what should you use instead? Let's see.

Semantic HTML is now the recommended practice. It describes the content of the elements, so it's much easier to read, understand, and maintain.

Search engines can easily understand your website when you use semantic HTML. It's also helpful for accessibility purposes, because screen readers need semantic information to describe what's on the web page.

Examples of semantic HTML elements include:

- The `header` element for defining the header of the document, or section.
- The navigation section element, `nav`, for sections with navigation links.
- The `section` element for grouping related information.
- The `figure` element for illustrations and diagrams.

This is an example of a `header` element that contains a navigation section element.

Enable the interactive editor and add a `<a href="#">Products</a>` inside of the `nav` and see the changes in the preview window.

:::interactive_editor

```html
<header>
  <nav>
    <a href="#">Home</a>
    <a href="#">About</a>
    <!--Add the products link here-->

    <a href="#">Contact</a>
  </nav>
</header>
```

:::

The semantic elements clearly show their purpose within the HTML structure. There are many different semantic HTML elements. You will definitely find one that fits the needs of your project.

Great work. Now you know the difference between presentational and semantic HTML: semantic HTML describes the content, while presentational HTML focuses on the appearance.

# --questions--

## --text--

Which of the following best describes the difference between presentational and semantic HTML?

## --answers--

Presentational HTML focuses on content structure, while semantic HTML focuses on appearance.

### --feedback--

Think about what "presentation" and "semantics" mean and how they are related to HTML elements.

---

Semantic HTML focuses on content structure, while presentational HTML focuses on appearance.

---

There is no difference between presentational and semantic HTML.

### --feedback--

Think about what "presentation" and "semantics" mean and how they are related to HTML elements.

---

Both focus on style, but presentational HTML is more modern.

### --feedback--

Think about what "presentation" and "semantics" mean and how they are related to HTML elements.

## --video-solution--

2

## --text--

Which of the following is an example of presentational HTML?

## --answers--

Using the `header` element to define a header.

### --feedback--

Think about which element directly controls how the content will look.

---

Using the `nav` element to define a navigation section.

### --feedback--

Think about which element directly controls how the content will look.

---

Using the `article` element to define independent content.

### --feedback--

Think about which element directly controls how the content will look.

---

Using the `center` element to center the content.

## --video-solution--

4

## --text--

Which of the following is an example of semantic HTML?

## --answers--

Using `<font color="red">` to make text red.

### --feedback--

Think about which element describes the meaning of the content.

---

Using the `center` element to center the content.

### --feedback--

Think about which element describes the meaning of the content.

---

Using the `nav` element to represent a navigation section

---

Using the `big` element to make text bigger.

### --feedback--

Think about which element describes the meaning of the content.

## --video-solution--

3
