---
id: 672985445d7da807c6b4f406
title: Why is it Important to Have Good Structural Hierarchy?
challengeType: 19
dashedName: why-is-it-important-to-have-good-structural-hierarchy
---

# --interactive--

The most important aspect of creating a structural hierarchy is the proper use of heading elements. Heading elements are numbered as `h1`, `h2`, `h3`, and so on. These numbers represent the heading level for that element.

Much like a text document, you do not want to use heading levels in the incorrect order. Your `h1` element is your top-level heading. You will rarely have more than one of these on a page, and it should typically come before all of your content.

Your `h2` element is your subheading. It should always come after your `h1` and might come after some introductory text. Unlike an `h1` element, you can have multiple `h2` elements on your page. You'll often do this to delineate different sections of content. 

Following the pattern, your `h3` element should always come after an `h2` element. That is, you should never skip directly from `h1` to `h3`. You can, however, have multiple heading elements at the same level. For example, this code is correct:

```html
<section>
  <h1>freeCodeCamp</h1>
  <h2>Learn Front-End Development</h2>
  <h2>Learn Back-End Development</h2>
</section>
```

But this code would not be correct, because `h3` comes before `h2`. 

Move the `h2` element above the `h3` so it is semantically correct. To interact with the code, you will need to enable the interactive editor.

:::interactive_editor

```html
<section>
  <h1>freeCodeCamp</h1>
  <h3>Introduction to HTML</h3>
  <h2>Learn Frontend Development</h2>
</section>
```

:::

It may be tempting to use a specific heading element because of its styling, such as `h1` for large text:

:::interactive_editor

```html
<article>
  <p>
    Here is some
    <h1>Large Text</h1>
  </p>
</article>
```

:::

Instead, you should choose the appropriate element for your document structure and use CSS to achieve the styling you'd like.

Using the right hierarchy is important for accessibility. Assistive technologies, like screen readers, rely on the structure of a web page to determine how to parse and announce that web page to the user. Using an `h3` element after an `h1` might cause a screen reader user to believe they have accidentally skipped over important content, due to the lack of an `h2` element.

Proper structure is also important for SEO. Search engines use automation to parse the content of your web page and determine when and where it should show up in results. If your structure is malformed, search engines may not be able to rank you very well in the relevant search results.

Finally, depending on how incorrect your structure is, your HTML may not even be technically valid. When this happens, the web browser has to effectively guess what you meant to do. And what it guesses might not even be what you want at all. 

As you have learned today, there are many reasons to use the proper structural hierarchy for your page. Keep this in mind as you build new projects.

# --questions--

## --text--

Why is structural hierarchy important?

## --answers--

Accessibility

### --feedback--

There are many reasons why structural hierarchy is important.

---

SEO

### --feedback--

There are many reasons why structural hierarchy is important.

---

So browsers know what we mean

### --feedback--

There are many reasons why structural hierarchy is important.

---

All of the above

## --video-solution--

4

## --text--

Which heading element must precede an `h3` element?

## --answers--

`h5`

### --feedback--

Think about the order of headings. For example, an `h2` should come after an `h1`.

---

`h2`

---

`h6`

### --feedback--

Think about the order of headings. For example, an `h2` should come after an `h1`.

---

`h4`

### --feedback--

Think about the order of headings. For example, an `h2` should come after an `h1`.

## --video-solution--

2

## --text--

How should you create larger text on your page?

## --answers--

Use any element you want, and style it with CSS.

### --feedback--

CSS controls your style, and you want to select the right element for the job.

---

Use an `h1` because it already has large text.

### --feedback--

CSS controls your style, and you want to select the right element for the job.

---

Use a `span` element.

### --feedback--

CSS controls your style, and you want to select the right element for the job.

---

Use the correct structural element, and style it with CSS.

## --video-solution--

4
