---
id: 672a537f05f3798bd4f57d2d
title: What Are Some Common Accessibility Auditing Tools to Use?
challengeType: 19
dashedName: what-are-some-common-accessibility-auditing-tools
---

# --description--

Accessibility is a crucial yet often overlooked aspect of digital content. When making your digital content accessible, it's important to ensure it meets accessibility standards.

An accessibility auditing tool is an application that helps you improve the accessibility of your digital content by reporting accessibility issues that can be easily found through automated testing. This content includes websites, web applications, and mobile apps.

It is important to note that while automated accessibility tools have a role in improving accessibility, they typically will only find about a third of all possible accessibility issues. Therefore, it is important not to rely on them entirely to evaluate the accessibility of your content. Manual testing, preferably by people with disabilities, will always be required to ensure that your content is as accessible as possible.

Let's look at some free tools that can help you improve the accessibility of your digital content.

Google Lighthouse is a popular web metric checker you can use directly within Chrome DevTools or online. This means you can check not only live websites but also locally-developed ones.

The metrics you can check include accessibility, SEO, best practices, and performance.

To use Lighthouse, open your DevTools by pressing `F12` and switching to the Lighthouse tab.
Select the metrics you want to check, choose the device you want to test on, and click the "Analyze page load" button.

An accessibility score will appear after the check is complete, along with a list of any issues that need fixing.

If you want more reliable metrics, consider using the web version. The downside is that it doesn't support testing local websites. You can access the web version on `pagespeed.web.dev`.

WAVE is another reliable accessibility checker you can use as a Chrome extension or on the web. All you need to do is enter the URL of your website and a comprehensive accessibility report will be generated for you. This report includes accessibility features implemented, ARIA, and contrasts.

The IBM Equal Accessibility Checker is another robust tool for improving digital content accessibility. With it, you can scan your websites for accessibility issues and generate a detailed report.

You can use it as a Chrome extension or Firefox add-on.

To use the IBM Accessibility Checker as a Chrome extension, download it from the Chrome web store. Open your Devtools by pressing `F12` and selecting the "Accessibility Checker" tab located in the Elements panel. Click the scan button to start the check and a report will be generated for you. You can export the report as a spreadsheet and an HTML file by clicking the "Export XLS" button.

Please keep in mind, while these automated tools help you make your content more accessible, a perfect score from any of them does not mean that your content is entirely accessible. The range of issues that these tools test for is limited, and manual testing will always be needed to ensure a more accessible experience for everyone.

# --questions--

## --text--

Which of these best describes an accessibility auditing tool?

## --answers--

It automatically fixes all accessibility issues.

### --feedback--

Consider the role of the tool in assessing accessibility.

---

It evaluates how accessible your digital content is.

---

It only checks mobile apps.

### --feedback--

Consider the role of the tool in assessing accessibility.

---

It requires no manual input.

### --feedback--

Consider the role of the tool in assessing accessibility.

## --video-solution--

2

## --text--

Which of these describes how you can use the IBM Equal Access Accessibility Checker?

## --answers--

It can be used only as a desktop application.

### --feedback--

Think about the different ways you can integrate it into your workflow.

---

It can be used without any development integration.

### --feedback--

Think about the different ways you can integrate it into your workflow.

---

It's exclusively for mobile apps.

### --feedback--

Think about the different ways you can integrate it into your workflow.

---

It can be used as a Chrome extension, Firefox addon, or NPM package.

## --video-solution--

4

## --text--

Which of these is a limitation of using the web version of the tool on Google Lighthouse?

## --answers--

It provides unreliable metrics.

### --feedback--

Think about what the web version of Lighthouse cannot do with certain types of websites.

---

It can only test local websites.

### --feedback--

Think about what the web version of Lighthouse cannot do with certain types of websites.

---

It cannot test local websites.

---

It doesn't support mobile testing.

### --feedback--

Think about what the web version of Lighthouse cannot do with certain types of websites.

## --video-solution--

3
