---
id: 672a5361ef88158b25fbfba7
title: What Are Screen Magnifiers Used For?
challengeType: 19
dashedName: what-are-screen-magnifiers
---

# --description--

Screen magnifiers are tools that help people with low vision and other visual impairments better access digital content and the web.

Let's delve deeper into what these tools are and the role they play in digital content accessibility.

Screen magnifiers work by enlarging texts, graphics, and other elements on a computer or mobile device screen. Many screen magnifiers allow users to enlarge the display by more than 200%. Users can then navigate the page using their pointing device or keyboard. Additionally, most magnifiers offer customizable zoom percentages and other features in their settings.

Screen magnifiers primarily help people with low vision read text, as small fonts in documents or applications can be challenging for them. By enlarging the text, they can read emails, articles, and other content without straining their eyes. Screen magnifiers also assist with web browsing. They help users locate and click on buttons, links, and other interactive elements that might be difficult to see. This improved visibility ensures that users can browse websites, fill out forms, and engage in online activities without difficulty.

Therefore, software developers need to make their digital products accessible to people with low vision. Some considerations include:

- Using scalable fonts so the user can resize the page without the layout breaking.
- Ensuring the user interface adapts to different screen sizes through responsive design.
- Using high-contrast color schemes and customizable colors.
- Implementing a non-sticky and tiny navbar so users can still see content when using magnifiers.
- Using regular HTML text instead of images of text.
- Providing feedback directly next to the element that triggers it, and more.

All the mainstay Operating Systems have at least one magnifier built into them by their manufacturers:

- macOS and iOS both have Zoom. You can turn it on on macOS by going to Settings, filter by Accessibility, and then click on "Zoom". Toggle the "Use keyboard shortcuts to zoom" option to enable it.
  - You can turn it on on iPhone through _Settings > Accessibility > Zoom_.
- Android devices have Magnification. To turn it on, go to _Settings > Special Function > Accessibility> Magnification_. Since this may vary from device to device, you can search for "Magnification" on the settings homepage to access it.
- Windows has Magnifier. You can use it by going to _Settings > Ease of Access > Magnifier_.
- The magnifiers for Linux operating systems vary. It is either Zoom or Magnifier.

Apart from the ones built into operating systems, some useful third party screen magnifiers are:

- ZoomText for Windows.
- ClaroView for both macOS and Windows.
- iZoom for Windows.
- Zoomify - Screen Magnifier for macOS.
- LunarPluse for Windows.
- Loupe for macOS.

# --questions--

## --text--

How do most screen magnifiers work?

## --answers--

By providing text-to-speech functionality.

### --feedback--

Focus on how screen magnifiers help users with low vision increase the size of various elements on their screens, not just text.

---

By enlarging the texts, graphics, and other elements on a computer or mobile device screen.

---

By providing a ruler around every element on the page.

### --feedback--

Focus on how screen magnifiers help users with low vision increase the size of various elements on their screens, not just text.

---

By enlarging only the texts on a screen for better visibility.

### --feedback--

Focus on how screen magnifiers help users with low vision increase the size of various elements on their screens, not just text.

## --video-solution--

2

## --text--

Which of these should a developer do to make their digital products friendly to screen magnifiers?

## --answers--

Use big fonts only.

### --feedback--

Think about how content adjusts to different screen sizes for better responsiveness.

---

Disable zooming to keep the layout intact.

### --feedback--

Think about how content adjusts to different screen sizes for better responsiveness.

---

Rely only on images to convey information.

### --feedback--

Think about how content adjusts to different screen sizes for better responsiveness.

---

Make their pages respond to different screen sizes.

## --video-solution--

4

## --text--

Which of the following is a third-party screen magnifier?

## --answers--

Zoom

### --feedback--

Refer to the end of the lesson for the answer.

---

Loops

### --feedback--

Refer to the end of the lesson for the answer.

---

ZoomText

---

Loup

### --feedback--

Refer to the end of the lesson for the answer.

## --video-solution--

3
