---
id: 6733bee844600f35c05b8264
title: How Does try...catch...finally Work?
challengeType: 19
dashedName: how-does-try-catch-finally-work
---

# --interactive--

In the previous lesson, you learned how to throw exceptions in your programs. In this lesson, we will take a look at how to gracefully handle these errors in a `try…catch…finally` block.

The `try` block is used to wrap code that might throw an error. It acts as a safe space to try something that could fail.

The `catch` block captures and handles errors that occur in the `try` block. You can use the `Error` object inside `catch` to inspect what went wrong.

The `finally` block runs after the `try` and `catch` blocks, regardless of whether an error occurred. It’s commonly used for cleanup tasks, such as closing files or releasing resources.

Here is an example of using a `try…catch` block:

:::interactive_editor

```js
function processInput(input) {
  if (typeof input !== "string") {
    throw new TypeError("Input must be a string.");
  }

  return input.toUpperCase();
}

try {
  console.log("Starting to process input...");
  const result = processInput(9);
  console.log("Processed result:", result);
} catch (error) {
  console.error("Error occurred:", error.message);
} 
```

:::

In this example, we have a function called `processInput` that first checks if the `input` is not of type `string`. If that is the case, then we throw an error. Otherwise, we return the result of using the `toUpperCase` method on the `input`.

We call the function inside of a `try` block. Since the function call throws an error, then it will be caught inside the `catch` block and the error message will be displayed in the console. 

The error passed into the `catch` block is an `Error` object which contains information about that error. In this case, we are using the `message` property which displays human readable information to the user. 

We are using the `console.error` because it is designed specifically to log errors. In many modern browsers, the output of `console.error()` appears in red in the console.

The `finally` statement is executed regardless of if an exception was thrown or not.

```js
try {
  // Code that might throw an error
} catch (error) {
  // Code to handle the error
} finally {
  // Code that runs regardless of whether an error occurred or not
}
```

A good use case for the `finally` statement is if you were working with files. In JavaScript, you can open a file, use a `try` block to write data to the file. If there are any errors, you can use the `catch` to catch those errors. Then use the `finally` statement to close the file.

# --questions--

## --text--

What best describes the `try` block?

## --answers--

It’s for running code again automatically after an error occurs.

### --feedback--

Think about the order of blocks in `try…catch…finally` statements, and the types of tasks each block handles.

---

It’s for handling errors.

### --feedback--

Think about the order of blocks in `try…catch…finally` statements, and the types of tasks each block handles.

---

It’s for setup before an error is thrown.

### --feedback--

Think about the order of blocks in `try…catch…finally` statements, and the types of tasks each block handles.

---

It’s a safe wrapper for code that might throw an error.

## --video-solution--

4

## --text--

Which block always executes even if an error occurs?

## --answers--

`try`

### --feedback--

This block is often used for cleanup tasks.

---

`catch`

### --feedback--

This block is often used for cleanup tasks.

---

`finally`

---

`throw`

### --feedback--

This block is often used for cleanup tasks.

## --video-solution--

3

## --text--

What is the purpose of the `catch` block?

## --answers--

To execute code that might throw an error.

### --feedback--

This block activates when something goes wrong in the `try` block.

---

To define a safe space for code execution.

### --feedback--

This block activates when something goes wrong in the `try` block.

---

To handle errors gracefully without crashing the program.

---

To always execute, regardless of errors.

### --feedback--

This block activates when something goes wrong in the `try` block.

## --video-solution--

3
