---
id: 6733bec70d86e13522e98a4f
title: How Does the Throw Statement Work?
challengeType: 19
dashedName: how-does-the-throw-statement-work
---

# --description--

The `throw` statement in JavaScript is used to throw a user defined exception. An exception in programming, is when an unexpected event happens and disrupts the normal flow of the program.

As programmers it is important to handle these exceptions, so your programs don’t crash unexpectedly when errors occur. Here is the basic syntax for the `throw` statement:

```js
throw expression;
```

The `expression` in this case would be the object or value that represents the exception you want to throw. Examples of this would be the built in exception classes like the `Error`, `TypeError`, or `RangeError` class. Here is an example of using the `throw` statement to throw a `TypeError`:

```js
function validateNumber(input) {
  if (typeof input !== "number") {
    throw new TypeError("Expected a number, but received " + typeof input);
  }
  return input * 2;
}
```

In this example, we are checking if the type of `input` is not of type `number`. If not, then we are throwing a `TypeError` with a custom message. Otherwise, the function will return the result of multiplying the `input` by `2`. 

If you wanted to throw a more generic error message, then you can reference the `Error` constructor like this:

```js
function divide(numerator, denominator) {
  if (denominator === 0) {
    throw new Error("Cannot divide by zero");
  }
  return numerator / denominator;
}
```

Here is an example of a function that will check if the denominator is `0`. If that is the case, then it will throw a custom error message saying `Cannot divide by zero`.

In the next lesson, we will look at how to throw errors messages within the context of the `try`/`catch` block which is used to gracefully handle exceptions in JavaScript.

# --questions--

## --text--

What happens when you use the `throw` statement in JavaScript?

## --answers--

It continues the normal flow of the program.

### --feedback--

Think about how JavaScript reacts when no error handling is present after a `throw`.

---

It throws an error expression and stops the program if no error handler is found.

---

It fixes the error automatically.

### --feedback--

Think about how JavaScript reacts when no error handling is present after a `throw`.

---

It logs the error and proceeds with the next line of code.

### --feedback--

Think about how JavaScript reacts when no error handling is present after a `throw`.

## --video-solution--

2

## --text--

How can you ensure code runs smoothly after an error occurs?

## --answers--

Use a loop to skip the error.

### --feedback--

Think of a way to catch and handle errors without crashing the program.

---

Use the `try…catch` syntax to handle the error and allow code execution to continue.

---

Use the `throw` statement to skip the error.

### --feedback--

Think of a way to catch and handle errors without crashing the program.

---

Stop the program when an error is triggered.

### --feedback--

Think of a way to catch and handle errors without crashing the program.

## --video-solution--

2

## --text--

How do you use the `throw` statement in combination with the `Error` constructor in JavaScript?

## --answers--

`throw Error();`

### --feedback--

Think about creating a new `Error` object and throwing it.

---

`throw new Error();`

---

`Error throw();`

### --feedback--

Think about creating a new `Error` object and throwing it.

---

`new throw Error();`

### --feedback--

Think about creating a new `Error` object and throwing it.

## --video-solution--

2
