---
id: 672b8f382370e025aadd3f4e
title: How Does Inheritance Work with CSS at a High Level?
challengeType: 19
dashedName: how-does-inheritance-work-with-css-at-a-high-level
---

# --interactive--

Inheritance is a key concept in CSS that determines how styles are passed down from parent elements to their child elements.

Just like in the real world, where children often inherit traits from their parents, in CSS, certain properties can be inherited by child elements from their parent elements.

This allows for a more efficient way to apply consistent styling across an entire document.

In CSS, not all properties are inherited by default. For example, properties like `color`, `font-family`, and `line-height` are inherited. This means that if you set the text color on a parent element, all of its child elements will inherit that color unless you specifically override it.

For instance, consider the following example where a parent `div` element has its color set using an inline style, and the child `p` element inherits that color:

:::interactive_editor

```html
<div style="color: blue;">
  This is the parent element.
  <p>This is the child element inheriting the color.</p>
</div>
```

:::

In this case, both the parent `div` and the child `p` will display their text in blue because the color is inherited.

On the other hand, properties like `margin`, `padding`, `border`, and `background` are not inherited by default. If you want a child element to inherit these styles, you need to explicitly set them, either directly on the child element or by using the `inherit` keyword.

The `inherit` keyword can be used to force inheritance of a property from a parent element, even if that property is not normally inherited.

For example, if you want a specific child element to have the same `padding` as its parent, you can set `padding: inherit` on the child element:

:::interactive_editor

```html
<div style="padding: 20px;">
  This is the parent element with padding.
  <p style="padding: inherit;">This is the child element inheriting the padding.</p>
</div>
```

:::

In this case, the child `p` element will inherit the `20px` of padding from its parent `div` element.

Inheritance is especially useful for maintaining consistency and reducing redundancy in your stylesheets.

Instead of writing the same style rule for multiple elements, you can define it once on a parent element, and the child elements will inherit it. This can make your CSS more concise and easier to manage.

However, it’s important to remember that inheritance only works in one direction – from parent to child. If you override a style on a child element, it won’t affect the parent element.

# --questions--

## --text--

Which of the following CSS properties is typically inherited by default?

## --answers--

`padding`

### --feedback--

Think about the properties that are commonly applied to text.

---

`border`

### --feedback--

Think about the properties that are commonly applied to text.

---

`color`

---

`background`

### --feedback--

Think about the properties that are commonly applied to text.

## --video-solution--

3

## --text--

What keyword can be used to force a child element to inherit a property from its parent?

## --answers--

`default`

### --feedback--

This keyword explicitly tells the child to take the parent's value.

---

`inherit`

---

`initial`

### --feedback--

This keyword explicitly tells the child to take the parent's value.

---

`none`

### --feedback--

This keyword explicitly tells the child to take the parent's value.

## --video-solution--

2

## --text--

Given the following CSS, what will be the color of the `span` text inside the `p`?

```html
<head>
  <style>
    p {
      color: blue;
    }
  </style>
</head>
<body>
  <p>This is a <span>test</span>.</p>
</body>
```

## --answers--

`blue`

---

`red`

### --feedback--

Consider how inheritance works between parent and child elements.

---

`green`

### --feedback--

Consider how inheritance works between parent and child elements.

---

`black`

### --feedback--

Consider how inheritance works between parent and child elements.

## --video-solution--

1
