---
id: 672b8e8adcc27e235a154231
title: What Is the Specificity for Type Selectors?
challengeType: 19
dashedName: what-is-the-specificity-for-type-selectors
---

# --interactive--

Type selectors, also known as element selectors, target elements based on their tag name.

These selectors are fundamental in CSS and allow you to apply styles to all instances of a specific HTML element.

Type selectors are straightforward to use and are written simply as the tag name of the element you want to style.

Here is an example of a type selector targeting all paragraph elements on the page:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p>Paragraph one</p>
<p>Paragraph two</p>
<p>Paragraph three</p>
```

```css
p {
  color: blue;
}
```

:::

In this example, all `p` elements will have their text color set to `blue`.

Type selectors have a relatively low specificity compared to other selectors. The specificity value for a type selector is `(0, 0, 0, 1)`.

This means that type selectors will be overridden by class selectors, ID selectors, and inline styles, but can still apply styles unless those higher-specificity rules are present.

Let's take a look at an example where the class selectors will override the styles of the type selector.

Here is an example with two paragraph elements:

:::interactive_editor

```html
<p class="para">I am a paragraph</p>
<p class="para">Here is another paragraph</p>
```

:::

Both paragraph elements have a class called `para`.

Inside the CSS file, the type selector targets paragraphs, and the class selector targets elements with the `para` class.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p class="para">I am a paragraph</p>
<p class="para">Here is another paragraph</p>
```

```css
p {
  color: blue;
}

.para {
  color: red;
}
```

:::

All paragraphs on the page with the class of `para` will have the text color set to `red` instead of `blue` because class selectors have a higher specificity than type selectors.

# --questions--

## --text--

What is the specificity value of a type selector (e.g., `div`)?

## --answers--

(1, 0, 0, 0)

### --feedback--

This selector targets elements based on their tag name.

---

(0, 1, 0, 0)

### --feedback--

This selector targets elements based on their tag name.

---

(0, 0, 1, 0)

### --feedback--

This selector targets elements based on their tag name.

---

(0, 0, 0, 1)

## --video-solution--

4

## --text--

Which of the following has a lower specificity than a type selector?

## --answers--

A class selector.

### --feedback--

This selector targets all elements and has the lowest specificity.

---

An ID selector.

### --feedback--

This selector targets all elements and has the lowest specificity.

---

An Inline style.

### --feedback--

This selector targets all elements and has the lowest specificity.

---

A Universal selector.

## --video-solution--

4

## --text--

Given the following CSS, what will be the color of the text?

```html
<head>
  <style>
    * {
      color: blue;
    }
    p {
      color: red;
    }
  </style>
</head>
<body>
  <p>This text</p>
</body>
```

## --answers--

`blue`

### --feedback--

Consider the specificity of the selectors.

---

`red`

---

`green`

### --feedback--

Consider the specificity of the selectors.

---

`purple`

### --feedback--

Consider the specificity of the selectors.

## --video-solution--

2
