---
id: 672aa7005c24e45bbd53b20d
title: What Are Design Briefs and How Do Developers Work with Them?
challengeType: 19
dashedName: what-are-design-briefs
---

# --description--

When it comes to designing new features or applications, a good first step would be to create a design brief.

A design brief is a document that outlines the objectives, goals, and requirements of a project. It is a roadmap that guides the design process and ensures that the final product meets the needs of the client.

Usually the client will write the design brief and it will serve as a working draft. Sometimes, the designer might write one and consult with the client to make sure it meets their needs.

There are a few key elements that should be included in a design brief.

The first element is the overview of the project and business. This overview should include the company's details, mission, values, unique selling points, and products or services.

The next key element should be to document the goals and objectives for the project. This should include the purpose of the project, and the desired outcomes.

Examples of goals include increasing traffic to a site or increasing the number of monthly page visits by X percent.

Another key element would be the target audience. The design brief should include information about the target demographics, interests, and needs of the audience.

You should also include information about the competition and how the project will differentiate itself from the competition.

Another key element would be the project scope. This should include the deliverables, timeline, and budget. The deliverables should include a list of all the items that will be produced as part of the project, such as mockups, and final designs.

Without clearly defining project scope, things can get out of hand and go over budget. So, it's best to be as detailed as possible about what is expected to be delivered and by when.

One of the challenging aspects about project design is the timescale and budget. It is important to be realistic about what can be achieved within the given timeframe and budget. So, having a design brief that outlines these constraints is important.

Once all of these details have been discussed and documented, the design brief should be reviewed and approved by all stakeholders before the project begins. At that point, that is when the designers can get started with their work.

So, what is the developer's role in all of this? The developer's role is to take the designs, understand the project requirements, and turn them into a working product.

This involves writing code, testing, and debugging the application to ensure that it meets the requirements outlined in the design brief.

Oftentimes, developers will work in teams where the work is split up between multiple developers.

There will also usually be a project manager who will be responsible for coordinating the work and making sure that the project stays on track.

So, while you might not be involved in the design and initial decision making process as a developer, it is still important to understand the design brief and how it will impact your work.

# --questions--

## --text--

What is a design brief?

## --answers--

A timeline of past project milestones.

### --feedback--

Think about goals and objectives of a project.

---

A schedule of meetings and deadlines for a project team.

### --feedback--

Think about goals and objectives of a project.

---

A manual on how to use specific software tools.

### --feedback--

Think about goals and objectives of a project.

---

A document that outlines the objectives, goals, and requirements of a project.

## --video-solution--

4

## --text--

Why is it important to define the scope for a project in a design brief?

## --answers--

To plan the project's social media marketing strategy.

### --feedback--

Think about budget and timeline.

---

To ensure that the project stays on track and within budget.

---

To select the software tools for team collaboration.

### --feedback--

Think about budget and timeline.

---

To choose the best color palette for the project.

### --feedback--

Think about budget and timeline.

## --video-solution--

2

## --text--

What is the role of the developer in a project?

## --answers--

To change the timeline and deliverables in the design brief.

### --feedback--

Remember that the developer should not go against what was agreed upon in the design brief.

---

To take the design brief and turn it into a working product.

---

To change the design brief to meet the developer's preferences.

### --feedback--

Remember that the developer should not go against what was agreed upon in the design brief.

---

To change the project scope to include more features.

### --feedback--

Remember that the developer should not go against what was agreed upon in the design brief.

## --video-solution--

2
