---
id: 672ac9705b07a64439b73b59
title: How to Use a Search Engine Effectively to Achieve Optimal Results
challengeType: 19
dashedName: how-to-use-a-search-engine-effectively-to-achieve-optimal-results
---

# --description--

Searching for information on the Internet can be a daunting task. There are so many websites out there, with so much data, that it may seem impossible to get the results you want.

But thanks to things like boolean search syntax, you can narrow down your search to exactly what you need.

Boolean search syntax is a way to use special words to help you find exactly what you're looking for when searching online.

Here is an example of a basic search query for `freecodecamp curriculum`.

When you search for `freecodecamp curriculum`, the search engine will return results that match *any* of these keywords – typically sorted by relevance (how likely they are to match, or be related to, more of your query).

But what if you only wanted results that matched both keywords? Well, you might have heard that you can wrap a query in quotation marks, like `"freecodecamp curriculum"`.

However, this query specifically matches the *phrase* `freecodecamp curriculum`. This means that the results you will see will be limited to sites that say `freecodecamp curriculum` together, not sites that say `freecodecamp` AND `curriculum`.

If you want to match sites that include both of those terms, but not necessarily next to each other as a phrase, you can prefix each term with a plus symbol like this: `+freecodecamp +curriculum`

Alternatively, maybe you're interested in freeCodeCamp's initiatives outside of the curriculum. In this case, you can prefix the term `curriculum` with a minus symbol like this: `+freecodecamp -curriculum`.

This will return results that mention `freecodecamp`, but exclude results that also mention `curriculum`.

Or maybe you have a specific site you want to search, like our news platform? You can use `site:` followed by the URL of the site you want to search: `site:freecodecamp.org/news curriculum`.

This query returns all results from `freecodecamp.org/news` that contain the word `curriculum`.

By combining these tools, you can come up with very specific queries to get the exact information you need.

For example, the query `site:freecodecamp.org/news +python -curriculum` would search for Python articles on our news site, excluding articles that might talk about our curriculum.

Search operators may vary, so it is always important to check the documentation for your preferred search engine.

But you should now be empowered to get the exact results you want from your web searches.

# --questions--

## --text--

What is the purpose of using quotation marks around a search query?

## --answers--

To search for results containing any of the words.

### --feedback--

Think about how quotation marks are used in writing to represent exactly what the author said.

---

To search for an exact phrase.

---

To exclude certain words from the search.

### --feedback--

Think about how quotation marks are used in writing to represent exactly what the author said.

---

To search within a specific website.

### --feedback--

Think about how quotation marks are used in writing to represent exactly what the author said.

## --video-solution--

2

## --text--

Which symbol is used to exclude a term from search results?

## --answers--

`+`

### --feedback--

Remember the example given for searching for freeCodeCamp content while excluding curriculum-related results.

---

`` ` ``

### --feedback--

Remember the example given for searching for freeCodeCamp content while excluding curriculum-related results.

---

`:`

### --feedback--

Remember the example given for searching for freeCodeCamp content while excluding curriculum-related results.

---

`-`

## --video-solution--

4

## --text--

What does the `site:` operator do in a search query?

## --answers--

Excludes a specific site from search results.

### --feedback--

Recall the example using `site:freecodecamp.org/news` to search only the freeCodeCamp News site.

---

Searches for websites similar to the specified site.

### --feedback--

Recall the example using `site:freecodecamp.org/news` to search only the freeCodeCamp News site.

---

Limits the search to a specific website or domain.

---

Ranks the specified site higher in search results.

### --feedback--

Recall the example using `site:freecodecamp.org/news` to search only the freeCodeCamp News site.

## --video-solution--

3
