---
id: 672cf05c3ad533eabe1e8197
title: How Do Media Queries Work, and What Are Some Common Media Types and Features?
challengeType: 19
dashedName: how-do-media-queries-work
---

# --interactive--

Media queries are a fundamental component of responsive web design, allowing developers to apply different styles based on the characteristics of the user's device or browser. They provide a way to tailor the presentation of content to a variety of devices without changing the content itself.

At its core, a media query consists of a media type and one or more expressions that check for specific conditions. If these conditions are true, the corresponding styles are applied. This mechanism allows for the creation of responsive designs that adapt to different screen sizes, resolutions, and device capabilities.

The basic syntax of a media query in CSS looks like this:

```css
@media mediatype and (feature: value) {
  /* CSS rules go here */
}
```

In this structure, mediatype specifies the type of media the query applies to, and the feature: value pair defines the condition that must be met for the styles to be applied.

Media types describe the general category of a device. Let's talk about the most commonly used media types:

- `all` is suitable for all devices. This is the default if no media type is specified.

- `print` is intended for paged material and documents viewed on a screen in print preview mode.

- `screen` is intended primarily for screens.

In the past, there were more media types. like `handheld` and `tv`, but most of these have been deprecated in favor of using features to more precisely target devices.

Media features describe specific characteristics of the user agent, output device, or environment. Let's talk about some of the most commonly used media features. The `width` and `height` refers to the viewport width and height, and are often used with `min-` or `max-` prefixes for range queries. Here is an example:

```css
@media screen and (min-width: 768px) {
  /* Styles for screens at least 768px wide */
}
```

`aspect-ratio` describes the ratio between the width and height of the viewport. Here is an example:

```css
@media screen and (aspect-ratio: 16/9) {
  /* Styles for screens with a 16:9 aspect ratio */
}
```

The `orientation` feature indicates whether the device is in landscape or portrait orientation. Here is an example:

```css
@media screen and (orientation: landscape) {
  /* Styles for landscape orientation */
}
```

The `resolution` feature describes the resolution of the output device in dots per inch (dpi) or dots per centimeter (dpcm). Here is an example:

```css
@media screen and (min-resolution: 300dpi) {
  /* Styles for high-resolution screens */
}
```

The `hover` feature tests whether the primary input mechanism can hover over elements. Here is an example:

```css
@media (hover: hover) {
  /* Styles for devices that support hover */
}
```

The `prefers-color-scheme` feature detects if the user has requested a light or dark color theme. Here is an example:

```css
@media (prefers-color-scheme: dark) {
  /* Styles for dark mode */
}
```

Media queries can also combine multiple conditions using logical operators. The `and` operator is used to combine multiple media features, while `not` and `only` can be used to negate or isolate media queries. Here's an example that combines multiple features:

```css
@media screen and (min-width: 768px) and (orientation: landscape) {
  /* Styles for landscape screens at least 768px wide */
}
```

It's also possible to target multiple queries in a comma-separated list, which functions like an "or" operator:

```css
@media screen and (min-width: 768px), print {
  /* Styles for screens at least 768px wide OR for print */
}
```

When working with media queries, it's important to consider the cascade. Media queries don't increase specificity – they just group conditional rules. The normal rules of the CSS cascade still apply within each media query.

In practice, media queries are often used to create responsive layouts. A common pattern is to define a base style for mobile devices and then use media queries to enhance the layout for larger screens:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<div class="container">
  <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer nec odio. Praesent libero. Sed cursus ante dapibus diam.</p>
  <p>Sed nisi. Nulla quis sem at nibh elementum imperdiet. Duis sagittis ipsum. Praesent mauris. Fusce nec tellus sed augue semper porta.</p>
  <p>Mauris massa. Vestibulum lacinia arcu eget nulla. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.</p>
</div>
```

```css
/* Base styles for mobile */
.container {
  width: 100%;
  padding: 15px;
}

/* Styles for tablets */
@media screen and (min-width: 768px) {
  .container {
    width: 750px;
    margin: 0 auto;
  }
}

/* Styles for desktops */
@media screen and (min-width: 1024px) {
  .container {
    width: 960px;
  }
}
```

:::

This approach, known as "mobile-first" responsive design, ensures that the base styles are suitable for mobile devices, with enhancements added for larger screens.

In conclusion, media queries are a powerful tool in CSS that allow for the creation of responsive, adaptable web designs. By understanding how to use different media types and features, developers can create websites that provide optimal user experiences across a wide range of devices and preferences. As web technologies continue to evolve, staying updated with new media features can help in creating more nuanced and user-friendly responsive designs.

# --questions--

## --text--

Which of the following is NOT a commonly used media type in modern CSS?

## --answers--

`all`

### --feedback--

Consider which media types are still relevant in current web development practices.

---

`print`

### --feedback--

Consider which media types are still relevant in current web development practices.

---

`screen`

### --feedback--

Consider which media types are still relevant in current web development practices.

---

`handheld`

## --video-solution--

4

## --text--

What does the orientation media feature check for?

## --answers--

The physical orientation of the device.

### --feedback--

Think about how this feature relates to how content is displayed on a screen.

---

Whether the viewport is wider than it is tall, or vice versa.

---

The direction of text on the page.

### --feedback--

Think about how this feature relates to how content is displayed on a screen.

---

The geographical orientation of the user.

### --feedback--

Think about how this feature relates to how content is displayed on a screen.

## --video-solution--

2

## --text--

In a media query, what is the purpose of using the `and` operator?

## --answers--

To combine multiple CSS properties.

### --feedback--

Consider how you might check for multiple conditions in a single media query.

---

To add two numeric values together.

### --feedback--

Consider how you might check for multiple conditions in a single media query.

---

To combine multiple media features or types.

---

To create a logical `or` condition.

### --feedback--

Consider how you might check for multiple conditions in a single media query.

## --video-solution--

3
