---
id: 672c35a79fa53e00de9f2a49
title: What Are Best Practices for Hiding Content So It Doesn't Become Inaccessible?
challengeType: 19
dashedName: what-are-best-practices-for-hiding-content-so-it-doesnt-become-inaccessible
---

# --interactive--

Hiding content on a webpage is a common practice in web development, but it's crucial to do it in a way that doesn't compromise accessibility. Different hiding techniques can have varying impacts on how assistive technologies interpret and present the content to users. Let's explore some best practices for hiding content while maintaining accessibility. One common method to hide content is using `display: none`. Here's an example:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p class="hidden">Hidden text</p>
<p>Visible text</p>
```

```css
.hidden {
  display: none;
}
```

:::

While this effectively hides the content visually, it also removes it from the accessibility tree. The accessibility tree is a structure used by assistive technologies, such as screen readers, to interpret and interact with the content on a web page. It represents the content and its semantic meaning in a way that assistive technology can understand and present to the user.

Using `display: none` means that screen readers and other assistive technologies won’t be able to access this content, as it is not included in the accessibility tree. Therefore, it is important to use this method only when you want to completely remove content from both visual presentation and accessibility. 

Another approach to hiding content is using `visibility: hidden`:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p class="hidden">Hidden text</p>
<p>Visible text</p>
```

```css
.hidden {
  visibility: hidden;
}
```

:::

`visibility: hidden` hides the content visually but keeps it in the document flow, meaning it still occupies space on the page. Like `display: none`, `visibility: hidden` also removes content from the accessibility tree. This means that assistive technologies, like screen readers, will not be able to access the hidden content. Only use `visibility: hidden` when you want to hide content from everyone, including people who use assistive technology.

For content that should be hidden visually but remain accessible to screen readers, you can use a technique often referred to as "visually hidden" or "screen reader only". Here is an example using the `.sr-only` CSS class which is a common technique used to visually hide content while keeping it accessible to screen readers:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p class="sr-only">Hidden text</p>
<p>Visible text</p>
```

```css
.sr-only {
  position: absolute;
  width: 1px;
  height: 1px;
  padding: 0;
  margin: -1px;
  overflow: hidden;
  clip: rect(0, 0, 0, 0);
  white-space: nowrap;
  border: 0;
}
```

:::

In this example, we are using properties like `position`, `clip`, and `white-space`, which you will learn about in future lessons. For now, just know that this CSS rule effectively hides the content visually while keeping it accessible to screen readers. It's useful for providing additional context to screen reader users without affecting the visual layout. 

For toggling content visibility, consider using the `hidden` attribute:

:::interactive_editor

```html
<p hidden>This content is hidden</p>
<p>This content is visible</p>
```

:::

The `hidden` attribute is supported by most modern browsers and hides content both visually and from the accessibility tree. It can be easily toggled with JavaScript. Lastly, be cautious about hiding important content. If information is crucial for understanding or using the website, it should be visible and accessible to all users. Only hide content when doing so genuinely enhances the user experience. By following these best practices, you can ensure that your content remains accessible to all users, regardless of how they interact with your website.

# --questions--

## --text--

What is the main accessibility issue when using the `display: none` and `visibility: hidden` style declarations, or the `hidden` attribute to hide content?

## --answers--

These methods make it so that only assistive technologies like screen readers can access the hidden content.

### --feedback--

Think about the accessibility concern each of these methods has in common.

---

Content is only hidden until users move their mouse over the content.

### --feedback--

Think about the accessibility concern each of these methods has in common.

---

These methods remove the content from the accessibility tree, making it impossible for assistive technologies like screen readers to access the hidden content.

---

These methods do not work with some browsers.

### --feedback--

Think about the accessibility concern each of these methods has in common.

## --video-solution--

3

## --text--

What is the primary purpose of the "visually hidden" or "screen reader only" CSS technique?

## --answers--

To hide content from all users.

### --feedback--

Consider the needs of users who rely on screen readers.

---

To make content visible only on mobile devices.

### --feedback--

Consider the needs of users who rely on screen readers.

---

To hide content visually while keeping it accessible to screen readers.

---

To create animated transitions for content.

### --feedback--

Consider the needs of users who rely on screen readers.

## --video-solution--

3

## --text--

When should you hide content on a web page?

## --answers--

When the content you're hiding is less important than other content on the page.

### --feedback--

Think about how hiding content affects accessibility and the user experience as a whole. 

---

When the content you're hiding is incorrect.

### --feedback--

Think about how hiding content affects accessibility and the user experience as a whole. 

---

Only when it genuinely enhances the user experience.

---

Whenever you feel like it.

### --feedback--

Think about how hiding content affects accessibility and the user experience as a whole. 

## --video-solution--

3
