---
id: 672aa82768e00d600305afc0
title: What Are Some Tools to Check for Good Color Contrast on Sites?
challengeType: 19
dashedName: what-are-some-tools-to-check-for-good-color-contrast-on-sites
---

# --interactive--

When designing websites, ensuring good color contrast is crucial for accessibility and readability. Several tools are available to help developers and designers check and maintain appropriate color contrast ratios on their sites. One popular tool is WebAIM's Color Contrast Checker.

This online tool allows you to input the foreground and background colors of your design and instantly see if they meet the Web Content Accessibility Guidelines (WCAG) standards. It's user-friendly and provides immediate feedback on whether your color choices pass or fail the contrast requirements.

To use WebAIM's Color Contrast Checker, simply visit their website and enter the hexadecimal codes for your foreground and background colors. The tool will then calculate the contrast ratio and indicate whether it meets the WCAG 2.0 level AA or AAA standards. Here's an example of how you might use color values in your CSS:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p>Hello, World!</p>
```

```css
body {
  background-color: #FFFFFF;
  color: #333333;
}
```

:::

In this example, we've set a white background (`#FFFFFF`) and dark gray text (`#333333`). You can input these color codes into the WebAIM tool to check their contrast ratio.

Another valuable tool is the TPGi Colour Contrast Analyzer. This desktop application offers more advanced features compared to online tools. It allows you to analyze entire web pages, not just individual color pairs. You can use its color picker to select colors directly from your screen, making it easier to check contrast ratios for existing designs.

The TPGi Colour Contrast Analyzer also provides simulations for different types of color vision deficiencies, helping you ensure your design is accessible to users with various forms of color blindness.

To use the TPGi Colour Contrast Analyzer, download and install the application on your computer. Once installed, you can use its eyedropper tool to select colors from your screen and instantly see the contrast ratio. This is particularly useful when working with complex designs or checking contrast on live websites.

Both these tools are invaluable for creating accessible and readable websites. They help ensure that your text is legible against its background, which is essential for all users but particularly important for those with visual impairments. Remember, while these tools are extremely helpful, they should be used in conjunction with manual testing and user feedback. Different contexts and user needs may require adjustments beyond what automated tools can suggest.

By regularly using tools like WebAIM's Color Contrast Checker and the TPGi Colour Contrast Analyzer, you can create designs that are not only visually appealing but also inclusive and accessible to a wider audience. This attention to detail in color contrast can significantly improve the user experience of your website for all visitors.

# --questions--

## --text--

What is the primary purpose of using color contrast checking tools like WebAIM's Color Contrast Checker?

## --answers--

To make websites more colorful.

### --feedback--

Think about why contrast between text and background is important for users.

---

To ensure text is readable against its background for accessibility.

---

To reduce the number of colors used in a website.

### --feedback--

Think about why contrast between text and background is important for users.

---

To increase website loading speed.

### --feedback--

Think about why contrast between text and background is important for users.

## --video-solution--

2

## --text--

Which feature does the TPGi Colour Contrast Analyzer offer that most online contrast checkers don't?

## --answers--

It can check contrast ratios.

### --feedback--

Consider the advanced capabilities mentioned for this desktop application.

---

It provides hexadecimal color codes.

### --feedback--

Consider the advanced capabilities mentioned for this desktop application.

---

It can analyze entire web pages and simulate color vision deficiencies.

---

It suggests color combinations.

### --feedback--

Consider the advanced capabilities mentioned for this desktop application.

## --video-solution--

3

## --text--

What do the WCAG 2.0 level AA and AAA standards refer to in the context of color contrast tools?

## --answers--

The brightness levels of colors.

### --feedback--

These standards are related to the accessibility guidelines mentioned in the lesson.

---

The file size of images.

### --feedback--

These standards are related to the accessibility guidelines mentioned in the lesson.

---

The minimum contrast ratios required for accessibility.

---

The number of colors used in a design.

### --feedback--

These standards are related to the accessibility guidelines mentioned in the lesson.

## --video-solution--

3
