---
id: 672cf764cf55a70433590def
title: What Are Accessibility Concerns Around Using Animations, and How Can prefers-reduced-motion Help?
challengeType: 19
dashedName: what-are-accessibility-concerns-around-using-animations
---

# --description--

Animations can greatly enhance the visual appeal and user experience of a website. However, they can also pose significant accessibility challenges for certain users. It's crucial to understand these concerns and implement solutions to ensure your website remains accessible to all users.

One of the primary accessibility concerns with animations is that they can cause discomfort or even physical harm to some users. People with vestibular disorders or motion sensitivity may experience dizziness, nausea, or headaches when exposed to certain types of movement on screen.

Additionally, animations can be distracting for users with cognitive disabilities or attention disorders. Rapid flashing or strobing effects are particularly problematic. They can trigger seizures in people with photosensitive epilepsy. As a general rule, avoid any content that flashes more than three times per second.

Another issue is that animations can make it difficult for some users to focus on or read content. This is especially true for users with low vision or reading difficulties who may struggle to track moving text or shifting layouts.

To address these concerns, CSS provides the `prefers-reduced-motion` media query. This feature allows web developers to detect if the user has requested minimal animations or motion effects at the system level.

Here's how you can use `prefers-reduced-motion`:

```css
@media (prefers-reduced-motion: reduce) {
  * {
    animation-duration: 0.01ms !important;
    animation-iteration-count: 1 !important;
    transition-duration: 0.01ms !important;
    scroll-behavior: auto !important;
  }
}
```

This CSS code snippet effectively disables most animations and transitions for users who have indicated a preference for reduced motion. Let's break it down:

The `@media` query rule checks if the user prefers reduced motion. If true, it applies the enclosed styles.

Inside the media query, we're targeting all elements (`*`) and overriding animation and transition properties.

We set `animation-duration` and `transition-duration` to an extremely small value (`0.01ms`). This essentially turns off the animations while still allowing them to complete, which can be important for certain functionality.

`animation-iteration-count: 1` ensures that any looping animations only play once.

`scroll-behavior: auto` disables smooth scrolling effects.

The `!important` declaration is used to ensure these rules take precedence over other animation styles.

It's important to note that while this method effectively reduces motion, it's a blanket approach. For more precise control, you might want to define specific reduced-motion alternatives for your animations.

Here's an example of a more targeted approach:

```css
.animated-element {
  transition: transform 0.3s ease-in-out;
}

@media (prefers-reduced-motion: reduce) {
  .animated-element {
    transition: none;
  }
}
```

In this case, we're only disabling the `transition` for a specific element when reduced motion is preferred. This allows you to provide alternative, less motion-intensive experiences for users who need them.

Remember, the goal is not to completely remove all motion from your site, but to provide options that allow all users to comfortably interact with your content. Some motion can still be beneficial for usability and feedback, even for users who prefer reduced motion.

When implementing animations, consider using them thoughtfully rather than just for decoration. Avoid large, unexpected movements and provide controls to pause, stop, or hide animations when possible. Importantly, use the `prefers-reduced-motion` query to offer a low-motion alternative, ensuring your content remains accessible and comfortable for all users, including those sensitive to motion.

By being mindful of these accessibility concerns and utilizing tools like `prefers-reduced-motion`, you can create engaging, animated experiences that are inclusive and accessible to all users.

# --questions--

## --text--

What is the primary purpose of the `prefers-reduced-motion` media query?

## --answers--

To increase the speed of all animations.

### --feedback--

Think about how this query relates to user preferences for motion on their devices.

---

To detect if a user has requested minimal animations at the system level.

---

To automatically add more animations to a website.

### --feedback--

Think about how this query relates to user preferences for motion on their devices.

---

To change the color scheme of animations.

### --feedback--

Think about how this query relates to user preferences for motion on their devices.

## --video-solution--

2

## --text--

Which of the following is NOT a common accessibility concern related to animations?

## --answers--

They can cause discomfort for users with vestibular disorders.

### --feedback--

Consider how animations might affect different groups of users, including those with various disabilities.

---

They can be distracting for users with cognitive disabilities.

### --feedback--

Consider how animations might affect different groups of users, including those with various disabilities.

---

They always improve readability for all users.

---

They can trigger seizures in people with photosensitive epilepsy.

### --feedback--

Consider how animations might affect different groups of users, including those with various disabilities.

## --video-solution--

3

## --text--

In the context of `prefers-reduced-motion`, what does setting `animation-duration: 0.01ms !important;` achieve?

## --answers--

It makes animations last exactly 0.01 milliseconds.

### --feedback--

Think about the practical effect of an extremely short animation duration.

---

It increases the speed of animations.

### --feedback--

Think about the practical effect of an extremely short animation duration.

---

It effectively turns off animations while still allowing them to complete.

---

It makes animations last indefinitely.

### --feedback--

Think about the practical effect of an extremely short animation duration.

## --video-solution--

3
