---
id: 672aa8d65995be62ef1c7515
title: What Are CSS Animations, and How Do They Work?
challengeType: 19
dashedName: what-are-css-animations
---

# --interactive--

CSS animations allow you to create dynamic, visually engaging effects on web pages without the need for JavaScript or complex programming. They provide a way to smoothly transition elements between different styles over a specified duration.

At its core, a CSS animation consists of two main components: the `@keyframes` rule and the animation property.

The `@keyframes` rule defines the stages and styles of the animation. It specifies what styles the element should have at various points during the animation. 

Here's an example:

```css
@keyframes slide-in {
  0% {
    transform: translateX(-100%);
  }
  100% {
    transform: translateX(0);
  }
}
```

This `@keyframes` rule, named `slide-in`, defines an animation that moves an element from left to right. The percentages represent the progress of the animation, with `0%` being the start and `100%` being the end.

The `translateX` function in your `@keyframes` animation is controlling the horizontal position of an element as it animates into view.

To apply this animation to an element, you use the `animation` property. This example also repeats the animation infinitely so you can see it in action (you will need to enable the interactive editor to see previews):

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="sliding-element">Hello, I slide in!</div>
```

```css
@keyframes slide-in {
  0% {
    transform: translateX(-100%);
  }
  100% {
    transform: translateX(0);
  }
}

.sliding-element {
  animation: slide-in 2s ease-out infinite;
}
```

:::

This applies the `slide-in` animation to the element with a duration of 2 seconds and an `ease-out` timing function.

The `animation` property is actually a shorthand for several individual properties:

`animation-name` which specifies the `@keyframes` rule to use.

`animation-duration` which sets how long the animation should take to complete.

`animation-timing-function` which defines how the animation progresses over time - such as `ease`, `linear`, `ease-in-out`.

`animation-delay` which specifies a delay before the animation starts.

`animation-iteration-count` which sets how many times the animation should repeat.

`animation-direction` which determines whether the animation should play forwards, backwards, or alternate.

`animation-fill-mode` which specifies how the element should be styled before and after the animation.

`animation-play-state` which allows you to pause and resume the animation.

You can use these properties individually for more precise control:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="complex-animation">Watch my colors change!</div>
```

```css
.complex-animation {
  animation-name: color-change;
  animation-duration: 3s;
  animation-timing-function: linear;
  animation-delay: 1s;
  animation-iteration-count: infinite;
  animation-direction: alternate;
}

@keyframes color-change {
  0% {
    background-color: red;
  }
  50% {
    background-color: blue;
  }
  100% {
    background-color: green;
  }
}
```

:::

This creates an animation that continuously transitions an element's background color between red, blue, and green.

CSS animations can be triggered by various events, such as hovering over an element:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<button class="button">Hover over me!</button>
```

```css
.button {
  background-color: blue;
  transition: background-color 0.3s;
}

.button:hover {
  background-color: red;
}
```

:::

While this example uses the `transition` property, which is simpler for basic effects, it demonstrates how CSS can create interactive, animated elements.

It's important to note that while CSS animations are powerful, they should be used in moderation. Overuse of animations can lead to poor performance and may be distracting or problematic for users with certain accessibility needs. Always consider providing options to reduce or disable animations for users who prefer less motion.

CSS animations offer a way to create engaging, interactive web experiences without relying on JavaScript. By understanding the principles of `@keyframes` and `animation` properties, you can bring your web designs to life in a performant and accessible manner.

# --questions--

## --text--

What is the purpose of the `@keyframes` rule in CSS animations?

## --answers--

To specify the duration of the animation.

### --feedback--

Think about what `@keyframes` allows you to define in terms of the animation's appearance.

---

To define the stages and styles of the animation.

---

To set the timing function of the animation.

### --feedback--

Think about what `@keyframes` allows you to define in terms of the animation's appearance.

---

To determine how many times the animation repeats.

### --feedback--

Think about what `@keyframes` allows you to define in terms of the animation's appearance.

## --video-solution--

2

## --text--

In the following CSS code, what does `2s` represent?

```css
.element {
  animation: fade-in 2s ease-in;
}
```

## --answers--

The delay before the animation starts.

### --feedback--

Consider which aspect of the animation this value is controlling.

---

The number of times the animation repeats.

### --feedback--

Consider which aspect of the animation this value is controlling.

---

The duration of the animation.

---

The percentage of the animation's progress.

### --feedback--

Consider which aspect of the animation this value is controlling.

## --video-solution--

3

## --text--

Which CSS property would you use to make an animation repeat indefinitely?

## --answers--

`animation-loop: infinite;`

### --feedback--

Think about which property controls how many times an animation plays.

---

`animation-repeat: always;`

### --feedback--

Think about which property controls how many times an animation plays.

---

`animation-iteration-count: infinite;`

---

`animation-duration: endless;`

### --feedback--

Think about which property controls how many times an animation plays.

## --video-solution--

3
