---
id: 65ca0dc5dbf42a11c3cf1098
title: Step 51
challengeType: 20
dashedName: step-51
---

# --description--

Replace `pass` with an `if` statement that checks if the current node (`node`) is not empty. Then, recursively call `_inorder_traversal` with `node.left` and `result` as the arguments.

# --hints--

You should remove the existing `pass` keyword from the `_inorder_traversal` method.

```js
({
  test: () => {
    assert.isFalse(
      runPython(
        `_Node(_code).find_class("BinarySearchTree").find_function("_inorder_traversal").has_pass()`
      )
    );
  },
});

```

Your check condition should be `if node`.

```js
assert.match(code, /if\s+node:/);
```

You should call `_inorder_traversal` on the `node.left` inside the `if` block.

```js
assert.match(code, /self\._inorder_traversal\(\s*node\.left\s*,\s*result\s*\)/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key) 
        else:
            if node.left is None:
                return node.right
            elif node.right is None:
                return node.left   
            
            node.key = self._min_value(node.right)
            node.right = self._delete(node.right, node.key)   
        
        return node

    def delete(self, key):
        self.root = self._delete(self.root, key)

    def _min_value(self, node):
        while node.left is not None:
            node = node.left
        return node.key

--fcc-editable-region--
    def _inorder_traversal(self, node, result):
        pass
--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
