---
id: 65ca075e3184180309f4c1d9
title: Step 39
challengeType: 20
dashedName: step-39
---

# --description--

Inside the `else` block, replace `pass` with an `if` statement to check if the left child of the current node is `None`.

When `node.left` is `None`, there is no left child. Therefore, return the right child from the new `if` block as a replacement.

# --hints--

You should remove the `pass` keyword from the `else` block.

```js
({
  test: () => {
    const pyClassStr = runPython(
      `str(_Node(_code).find_class("BinarySearchTree").find_function("_delete"))`
    );
    assert.notInclude(pyClassStr, "pass");
  },
});
```

You should write an `if` statement that checks if `node.left` is `None`.

```js
assert.match(code, /if\s+node\.left\s*is\s*None/);
```

You should return the right child of the current node.

```js 
assert.match(code, /return\s+node\.right/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key) 
        else:
            pass   
--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
