---
id: 65ca06864129380054b55dc0
title: Step 36
challengeType: 20
dashedName: step-36
---

# --description--

Within the `if` block, replace `pass` with a call to the `_delete` method, passing the left child of the current node and the `key` as arguments. Assign the function call to the left node.

# --hints--

You should remove the `pass` keyword from the `if` statement.

```js
({
  test: () => {
    assert.isFalse(
      runPython(
        `_Node(_code).find_class("BinarySearchTree").find_function("_delete").find_if("key < node.key").find_bodies()[0].has_pass()`
      )
    );
  },
});
```

You should call the `_delete` method with `node.left` and the `key` as the arguments.

```js
assert.match(code, /self\._delete\(\s*node\.left\s*,\s*key\s*\)/);
```

You should assign the result of the `_delete()` call to the left child (`node.left`) of the current node.

```js
assert.match(code, /node\.left\s*=\s*self\._delete\(\s*node\.left\s*,\s*key\s*\)/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            pass

--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
