---
id: 65ca05f7cba1e6fe70527534
title: Step 34
challengeType: 20
dashedName: step-34
---

# --description--

Inside your `_delete` method, replace `pass` with an `if` statement that checks if the current `node` is `None`.

When the current node is `None`, the key to be deleted was not found. Therefore, return `node` from your `if` block.

# --hints--

You should remove the `pass` keyword from the `_delete` method.

```js
({
  test: () => {
    assert.isFalse(
      runPython(
        `_Node(_code).find_class("BinarySearchTree").find_function("_delete").has_pass()`
      )
    );
  },
});

```

You should write an `if` statement that checks if the current `node` is `None`.

```js
const after_split = code.split('def _delete(self, node, key):')[1];
assert.match(after_split, /if\s+node\s+is\s+None/);
```

You should return `node` inside your `if` block.

```js
const after_split = code.split('def _delete(self, node, key):')[1];
assert.match(after_split, /return\s+node/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        pass

--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))

```
