---
id: 65c645b838e7deb080fc25e0
title: Step 29
challengeType: 20
dashedName: step-29
---

# --description--

Now, the nodes have been inserted. To see if they have been correctly inserted, you can search for a node in the tree.

Outside the for loop, search for node `80` in the `bst` instance and add it to a `print` call. Also the first argument of the `print` function should be the `'Search for 80:'`

# --hints--

You should print the result of calling `bst.search(80)` and your `print` statement should have the first argument as `'Search for 80:'`.

```js
assert.match(code, /^print\(('|")Search for 80:('|"),\s*bst\.search\(80\)/gm);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None


class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

--fcc-editable-region--
```
