---
id: 65a450e8fb2c9d75c7378d28
title: Step 88
challengeType: 20
dashedName: step-88
---

# --description--

Since this time you are starting from an encrypted string to decrypt, you won't need the `encryption` variable anymore.

Delete `encryption` and the `print(encryption)` call. Also, comment out the last two lines of your code.

# --hints--

You should delete the `encryption` variable and its value.

```js
const commentless_code = __helpers.python.removeComments(code);
assert.isFalse(/encryption\s*=\s*encrypt\s*\(\s*text\s*,\s*custom_key\s*\)/.test(commentless_code))
```

You should not have `print(encryption)` in your code.

```js
const commentless_code = __helpers.python.removeComments(code);
assert.isFalse(/print\s*\(\s*encryption\s*\)/.test(commentless_code))
```

You should turn `decryption = decrypt(encryption, custom_key)` into a comment.

```js
assert(code.match(/#\s*decryption\s*=/));
```

You should turn `print(decryption)` into a comment.

```js
assert(code.match(/#\s*print\s*\(\s*decryption\s*\)/));
```

Your code contains invalid syntax and/or invalid indentation.

```js
({test: () => assert(true) })
```

# --seed--

## --seed-contents--

```py
text = 'mrttaqrhknsw ih puggrur'
custom_key = 'python'

def vigenere(message, key, direction=1):
    key_index = 0
    alphabet = 'abcdefghijklmnopqrstuvwxyz'
    final_message = ''

    for char in message.lower():

        # Append any non-letter character to the message
        if not char.isalpha():
            final_message += char
        else:        
            # Find the right key character to encode/decode
            key_char = key[key_index % len(key)]
            key_index += 1

            # Define the offset and the encrypted/decrypted letter
            offset = alphabet.index(key_char)
            index = alphabet.find(char)
            new_index = (index + offset*direction) % len(alphabet)
            final_message += alphabet[new_index]
    
    return final_message

def encrypt(message, key):
    return vigenere(message, key)
    
def decrypt(message, key):
    return vigenere(message, key, -1)
--fcc-editable-region--
encryption = encrypt(text, custom_key)
print(encryption)
decryption = decrypt(encryption, custom_key)
print(decryption)
--fcc-editable-region--
```
