---
id: 6555e1bfcd374e18c6be8e58
title: Step 91
challengeType: 20
dashedName: step-91
---

# --description--

In Python, there's a way to easily format strings. *f-strings* enable you to interpolate values in your strings. 

Interpolation means writing placeholders that will be replaced by the specified values when the program runs. For example, you can get the same result of `'Encrypted text: ' + text` with `f'Encrypted text: {text}'`. You need to put an `f` before the quotes to create the f-string and write the variables or expressions you want to interpolate between curly braces.

Modify the first `print()` call to use an f-string.

# --hints--

You should modify the `print('Encrypted text: ' + text)` call so that it prints the same result using an f-string.

```js
({ test: () => assert.match(code, /print\s*\(\s*f("|')Encrypted\stext:\s\{\s*text\s*\}\1\s*\)/) })
```

# --seed--

## --seed-contents--

```py
text = 'mrttaqrhknsw ih puggrur'
custom_key = 'python'

def vigenere(message, key, direction=1):
    key_index = 0
    alphabet = 'abcdefghijklmnopqrstuvwxyz'
    final_message = ''

    for char in message.lower():

        # Append any non-letter character to the message
        if not char.isalpha():
            final_message += char
        else:        
            # Find the right key character to encode/decode
            key_char = key[key_index % len(key)]
            key_index += 1

            # Define the offset and the encrypted/decrypted letter
            offset = alphabet.index(key_char)
            index = alphabet.find(char)
            new_index = (index + offset*direction) % len(alphabet)
            final_message += alphabet[new_index]
    
    return final_message

def encrypt(message, key):
    return vigenere(message, key)
    
def decrypt(message, key):
    return vigenere(message, key, -1)
--fcc-editable-region--
print('Encrypted text: ' + text)
print('Key: ' + custom_key)
--fcc-editable-region--
#decryption = decrypt(encryption, custom_key)
#print(decryption)
```
