---
id: 6555231eac4d9f19bd3d44b5
title: Step 83
challengeType: 20
dashedName: step-83
---

# --description--

The `pass` keyword can be used as a placeholder for future code. It does not have any effect in your code but it can save you from errors you would get in case of incomplete code:

```py
def foo():
    pass
```

Calling `vigenere` with `1` to encrypt and `-1` to decrypt is fine but it might be a little bit cryptic. Create a new function called `encrypt` that takes `message` and `key` parameters, and use `pass` to fill the function body.


# --hints--

You should declare a new function called `encrypt`. Remember to use the `pass` keyword inside the body.

```js
({ test: () => assert(runPython(`
    import inspect
    inspect.isfunction(encrypt)
  `))
})
```

Your `encrypt` function should take `message` and `key` as the parameters. The order matters.

```js
({ test: () => assert(runPython(`
    import inspect
    sig = inspect.signature(encrypt)
    str(sig) == "(message, key)"
  `))
})
```

# --seed--

## --seed-contents--

```py
text = 'Hello Zaira!'
custom_key = 'python'

def vigenere(message, key, direction=1):
    key_index = 0
    alphabet = 'abcdefghijklmnopqrstuvwxyz'
    final_message = ''

    for char in message.lower():

        # Append any non-letter character to the message
        if not char.isalpha():
            final_message += char
        else:        
            # Find the right key character to encode/decode
            key_char = key[key_index % len(key)]
            key_index += 1

            # Define the offset and the encrypted/decrypted letter
            offset = alphabet.index(key_char)
            index = alphabet.find(char)
            new_index = (index + offset*direction) % len(alphabet)
            final_message += alphabet[new_index]
    
    return final_message
--fcc-editable-region--

encryption = vigenere(text, custom_key)
print(encryption)
decryption = vigenere(encryption, custom_key, -1)
print(decryption)
--fcc-editable-region--
```
