---
id: 6554ad2463b8892748f8efdd
title: Step 67
challengeType: 20
dashedName: step-67
---

# --description--

At the moment, your function prints some strings, but these values cannot be used by other parts of code to perform any actions.

For that purpose, you need to use a `return` statement:

```python
def foo():
    return 'spam'
```

You need to write `return` followed by a space and the value that the function should return. Once the `return` statement is found, that value is returned and the execution of the function stops, proceeding to the next line of code after the function call. In the example above, the `foo` function returns the string `'spam'`.

Remove the two `print()` calls from your function and return `encrypted_text`.

# --hints--

You should remove the two `print()` calls from your function.

```js
({ 
  test: () => {
    const commentless_code = __helpers.python.removeComments(code);
    assert.isFalse(/print\s*\(\s*("|')plain\stext:\1\s*,\s*message\s*\)/.test(commentless_code))
    assert.isFalse(/print\s*\(\s*("|')encrypted\stext:\1\s*,\s*encrypted_text\s*\)/.test(commentless_code))
  }
})
```

Your function should return `encrypted_text`.

```js
({ test: () => {
    const commentless_code = __helpers.python.removeComments(code);
    const {function_body} = __helpers.python.getDef(commentless_code, "vigenere");
    const {block_body} = __helpers.python.getBlock(commentless_code, /for\s+char\s+in\s+message\.lower\s*\(\s*\)\s*/);
    const regex = /return\s+encrypted_text/
    assert(function_body.match(regex));
    assert.notMatch(block_body, regex);
  }
})
```

# --seed--

## --seed-contents--

```py
text = 'Hello Zaira'
custom_key = 'python'

def vigenere(message, key):
    key_index = 0
    alphabet = 'abcdefghijklmnopqrstuvwxyz'
    encrypted_text = ''

    for char in message.lower():
    
        # Append space to the message
        if char == ' ':
            encrypted_text += char
        else:        
            # Find the right key character to encode
            key_char = key[key_index % len(key)]
            key_index += 1
--fcc-editable-region--
            # Define the offset and the encrypted letter
            offset = alphabet.index(key_char)
            index = alphabet.find(char)
            new_index = (index + offset) % len(alphabet)
            encrypted_text += alphabet[new_index]
    print('plain text:', message)
    print('encrypted text:', encrypted_text)
--fcc-editable-region--
```
