---
id: 6601918b44a11b4a8c986c6a
title: Step 67
challengeType: 20
dashedName: step-67
---

# --description--

The `__gt__` method is called under the hood when the `>` operator is used to compare an object with something else.

After the `__lt__` method, in the same way you did for `__lt__`, implement the `__gt__` method. Pay attention to use the appropriate operator.

# --hints--

You should define a `__gt__` method within the `R2Vector` class.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").has_function("__gt__")`)) })
```

Your `__lt__` method should have two parameters, `self` and `other`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__gt__").has_args("self, other")`)) })
```

You should create an `if` statement that checks if `self` and `other` do not belong to the same class.

```js
({ test: () => assert(runPython(`
node = _Node(_code).find_class("R2Vector").find_function("__gt__").find_ifs()[0].find_conditions()[0]
node.is_equivalent("type(self) != type(other)") or node.is_equivalent("type(other) != type(self)")`)) })
```

You should return `NotImplemented` from your `if` body.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__gt__").find_ifs()[0].find_bodies()[0].has_return("NotImplemented")`)) })
```

The `__gt__` method should return the result of comparing the norm of the current instance with the norm of `other` using the greater than operator.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("R2Vector").find_function("__gt__").has_return("self.norm() > other.norm()")`)) })
```

# --seed--

## --seed-contents--

```py
class R2Vector:
    def __init__(self, *, x, y):
        self.x = x
        self.y = y

    def norm(self):
        return sum(val**2 for val in vars(self).values())**0.5

    def __str__(self):
        return str(tuple(getattr(self, i) for i in vars(self)))

    def __repr__(self):
        arg_list = [f'{key}={val}' for key, val in vars(self).items()]
        args = ', '.join(arg_list)
        return f'{self.__class__.__name__}({args})'

    def __add__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) + getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __sub__(self, other):
        if type(self) != type(other):
            return NotImplemented
        kwargs = {i: getattr(self, i) - getattr(other, i) for i in vars(self)}
        return self.__class__(**kwargs)

    def __mul__(self, other):
        if type(other) in (int, float):
            kwargs = {i: getattr(self, i) * other for i in vars(self)}
            return self.__class__(**kwargs)        
        elif type(self) == type(other):
            args = [getattr(self, i) * getattr(other, i) for i in vars(self)]
            return sum(args)            
        return NotImplemented

    def __eq__(self, other):
        if type(self) != type(other):
            return NotImplemented
        return all(getattr(self, i) == getattr(other, i) for i in vars(self))
        
    def __ne__(self, other):
        return not self == other
--fcc-editable-region--
    def __lt__(self, other):
        if type(self) != type(other):
            return NotImplemented
        return self.norm() < other.norm()


--fcc-editable-region--
class R3Vector(R2Vector):
    def __init__(self, *, x, y, z):
        super().__init__(x=x, y=y)
        self.z = z

v1 = R2Vector(x=2, y=3)
v2 = R2Vector(x=0.5, y=1.25)
print(f'v1 = {v1}')
print(f'v2 = {v2}')
v3 = v1 + v2
print(f'v1 + v2 = {v3}')
v4 = v1 - v2
print(f'v1 - v2 = {v4}')
v5 = v1 * v2
print(f'v1 * v2 = {v5}')
print(v1 != R2Vector(x=2, y=3))

```
